/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.IdentificationField;
import org.cip4.lib.xjdf.type.URI;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"identificationField"})
@XmlRootElement(name="Module")
public class Module
implements Serializable {
    @XmlElement(name="IdentificationField")
    protected List<IdentificationField> identificationField;
    @XmlAttribute(name="DescriptiveName")
    protected String descriptiveName;
    @XmlAttribute(name="Manufacturer")
    protected String manufacturer;
    @XmlAttribute(name="ManufacturerURL")
    @XmlJavaTypeAdapter(value=URI.class)
    protected URI manufacturerURL;
    @XmlAttribute(name="ModuleID", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String moduleID;
    @XmlAttribute(name="ModuleType")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> moduleType;
    @XmlAttribute(name="Revision")
    protected String revision;
    @XmlAttribute(name="SerialNumber")
    protected String serialNumber;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public List<IdentificationField> getIdentificationField() {
        if (this.identificationField == null) {
            this.identificationField = new ArrayList<IdentificationField>();
        }
        return this.identificationField;
    }

    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    public void setDescriptiveName(String value) {
        this.descriptiveName = value;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String value) {
        this.manufacturer = value;
    }

    public URI getManufacturerURL() {
        return this.manufacturerURL;
    }

    public void setManufacturerURL(URI value) {
        this.manufacturerURL = value;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public void setModuleID(String value) {
        this.moduleID = value;
    }

    public List<String> getModuleType() {
        if (this.moduleType == null) {
            this.moduleType = new ArrayList<String>();
        }
        return this.moduleType;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String value) {
        this.revision = value;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String value) {
        this.serialNumber = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Module withIdentificationField(IdentificationField ... values) {
        if (values != null) {
            for (IdentificationField value : values) {
                this.getIdentificationField().add(value);
            }
        }
        return this;
    }

    public Module withIdentificationField(Collection<IdentificationField> values) {
        if (values != null) {
            this.getIdentificationField().addAll(values);
        }
        return this;
    }

    public Module withDescriptiveName(String value) {
        this.setDescriptiveName(value);
        return this;
    }

    public Module withManufacturer(String value) {
        this.setManufacturer(value);
        return this;
    }

    public Module withManufacturerURL(URI value) {
        this.setManufacturerURL(value);
        return this;
    }

    public Module withModuleID(String value) {
        this.setModuleID(value);
        return this;
    }

    public Module withModuleType(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getModuleType().add(value);
            }
        }
        return this;
    }

    public Module withModuleType(Collection<String> values) {
        if (values != null) {
            this.getModuleType().addAll(values);
        }
        return this;
    }

    public Module withRevision(String value) {
        this.setRevision(value);
        return this;
    }

    public Module withSerialNumber(String value) {
        this.setSerialNumber(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<String> rightModuleType;
        List<IdentificationField> rightIdentificationField;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Module that = (Module)object;
        List<IdentificationField> leftIdentificationField = this.identificationField != null && !this.identificationField.isEmpty() ? this.getIdentificationField() : null;
        List<IdentificationField> list = rightIdentificationField = that.identificationField != null && !that.identificationField.isEmpty() ? that.getIdentificationField() : null;
        if (this.identificationField != null && !this.identificationField.isEmpty()) {
            if (that.identificationField == null || that.identificationField.isEmpty()) return false;
            if (!leftIdentificationField.equals(rightIdentificationField)) {
                return false;
            }
        } else if (that.identificationField != null && !that.identificationField.isEmpty()) {
            return false;
        }
        String leftDescriptiveName = this.getDescriptiveName();
        String rightDescriptiveName = that.getDescriptiveName();
        if (this.descriptiveName != null) {
            if (that.descriptiveName == null) return false;
            if (!leftDescriptiveName.equals(rightDescriptiveName)) {
                return false;
            }
        } else if (that.descriptiveName != null) {
            return false;
        }
        String leftManufacturer = this.getManufacturer();
        String rightManufacturer = that.getManufacturer();
        if (this.manufacturer != null) {
            if (that.manufacturer == null) return false;
            if (!leftManufacturer.equals(rightManufacturer)) {
                return false;
            }
        } else if (that.manufacturer != null) {
            return false;
        }
        URI leftManufacturerURL = this.getManufacturerURL();
        URI rightManufacturerURL = that.getManufacturerURL();
        if (this.manufacturerURL != null) {
            if (that.manufacturerURL == null) return false;
            if (!leftManufacturerURL.equals((Object)rightManufacturerURL)) {
                return false;
            }
        } else if (that.manufacturerURL != null) {
            return false;
        }
        String leftModuleID = this.getModuleID();
        String rightModuleID = that.getModuleID();
        if (this.moduleID != null) {
            if (that.moduleID == null) return false;
            if (!leftModuleID.equals(rightModuleID)) {
                return false;
            }
        } else if (that.moduleID != null) {
            return false;
        }
        List<String> leftModuleType = this.moduleType != null && !this.moduleType.isEmpty() ? this.getModuleType() : null;
        List<String> list2 = rightModuleType = that.moduleType != null && !that.moduleType.isEmpty() ? that.getModuleType() : null;
        if (this.moduleType != null && !this.moduleType.isEmpty()) {
            if (that.moduleType == null || that.moduleType.isEmpty()) return false;
            if (!leftModuleType.equals(rightModuleType)) {
                return false;
            }
        } else if (that.moduleType != null && !that.moduleType.isEmpty()) {
            return false;
        }
        String leftRevision = this.getRevision();
        String rightRevision = that.getRevision();
        if (this.revision != null) {
            if (that.revision == null) return false;
            if (!leftRevision.equals(rightRevision)) {
                return false;
            }
        } else if (that.revision != null) {
            return false;
        }
        String leftSerialNumber = this.getSerialNumber();
        String rightSerialNumber = that.getSerialNumber();
        if (this.serialNumber != null) {
            if (that.serialNumber == null) return false;
            if (leftSerialNumber.equals(rightSerialNumber)) return true;
            return false;
        }
        if (that.serialNumber == null) return true;
        return false;
    }

    public int hashCode() {
        List<String> theModuleType;
        List<IdentificationField> theIdentificationField;
        int currentHashCode = 1;
        currentHashCode *= 31;
        List<IdentificationField> list = theIdentificationField = this.identificationField != null && !this.identificationField.isEmpty() ? this.getIdentificationField() : null;
        if (this.identificationField != null && !this.identificationField.isEmpty()) {
            currentHashCode += theIdentificationField.hashCode();
        }
        currentHashCode *= 31;
        String theDescriptiveName = this.getDescriptiveName();
        if (this.descriptiveName != null) {
            currentHashCode += theDescriptiveName.hashCode();
        }
        currentHashCode *= 31;
        String theManufacturer = this.getManufacturer();
        if (this.manufacturer != null) {
            currentHashCode += theManufacturer.hashCode();
        }
        currentHashCode *= 31;
        URI theManufacturerURL = this.getManufacturerURL();
        if (this.manufacturerURL != null) {
            currentHashCode += theManufacturerURL.hashCode();
        }
        currentHashCode *= 31;
        String theModuleID = this.getModuleID();
        if (this.moduleID != null) {
            currentHashCode += theModuleID.hashCode();
        }
        currentHashCode *= 31;
        List<String> list2 = theModuleType = this.moduleType != null && !this.moduleType.isEmpty() ? this.getModuleType() : null;
        if (this.moduleType != null && !this.moduleType.isEmpty()) {
            currentHashCode += theModuleType.hashCode();
        }
        currentHashCode *= 31;
        String theRevision = this.getRevision();
        if (this.revision != null) {
            currentHashCode += theRevision.hashCode();
        }
        currentHashCode *= 31;
        String theSerialNumber = this.getSerialNumber();
        if (this.serialNumber != null) {
            currentHashCode += theSerialNumber.hashCode();
        }
        return currentHashCode;
    }
}

