/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="NotificationFilter")
public class NotificationFilter
implements Serializable {
    @XmlAttribute(name="Classes")
    protected List<Class> classes;
    @XmlAttribute(name="MilestoneTypes")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> milestoneTypes;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public List<Class> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<Class>();
        }
        return this.classes;
    }

    public List<String> getMilestoneTypes() {
        if (this.milestoneTypes == null) {
            this.milestoneTypes = new ArrayList<String>();
        }
        return this.milestoneTypes;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public NotificationFilter withClasses(Class ... values) {
        if (values != null) {
            for (Class value : values) {
                this.getClasses().add(value);
            }
        }
        return this;
    }

    public NotificationFilter withClasses(Collection<Class> values) {
        if (values != null) {
            this.getClasses().addAll(values);
        }
        return this;
    }

    public NotificationFilter withMilestoneTypes(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getMilestoneTypes().add(value);
            }
        }
        return this;
    }

    public NotificationFilter withMilestoneTypes(Collection<String> values) {
        if (values != null) {
            this.getMilestoneTypes().addAll(values);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<String> rightMilestoneTypes;
        List<Class> rightClasses;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        NotificationFilter that = (NotificationFilter)object;
        List<Class> leftClasses = this.classes != null && !this.classes.isEmpty() ? this.getClasses() : null;
        List<Class> list = rightClasses = that.classes != null && !that.classes.isEmpty() ? that.getClasses() : null;
        if (this.classes != null && !this.classes.isEmpty()) {
            if (that.classes == null || that.classes.isEmpty()) return false;
            if (!leftClasses.equals(rightClasses)) {
                return false;
            }
        } else if (that.classes != null && !that.classes.isEmpty()) {
            return false;
        }
        List<String> leftMilestoneTypes = this.milestoneTypes != null && !this.milestoneTypes.isEmpty() ? this.getMilestoneTypes() : null;
        List<String> list2 = rightMilestoneTypes = that.milestoneTypes != null && !that.milestoneTypes.isEmpty() ? that.getMilestoneTypes() : null;
        if (this.milestoneTypes != null && !this.milestoneTypes.isEmpty()) {
            if (that.milestoneTypes == null || that.milestoneTypes.isEmpty()) return false;
            if (leftMilestoneTypes.equals(rightMilestoneTypes)) return true;
            return false;
        }
        if (that.milestoneTypes == null || that.milestoneTypes.isEmpty()) return true;
        return false;
    }

    public int hashCode() {
        List<String> theMilestoneTypes;
        List<Class> theClasses;
        int currentHashCode = 1;
        currentHashCode *= 31;
        List<Class> list = theClasses = this.classes != null && !this.classes.isEmpty() ? this.getClasses() : null;
        if (this.classes != null && !this.classes.isEmpty()) {
            currentHashCode += theClasses.hashCode();
        }
        currentHashCode *= 31;
        List<String> list2 = theMilestoneTypes = this.milestoneTypes != null && !this.milestoneTypes.isEmpty() ? this.getMilestoneTypes() : null;
        if (this.milestoneTypes != null && !this.milestoneTypes.isEmpty()) {
            currentHashCode += theMilestoneTypes.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Class {
        EVENT("Event"),
        INFORMATION("Information"),
        WARNING("Warning"),
        ERROR("Error"),
        FATAL("Fatal");

        private final String value;

        private Class(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Class fromValue(String v) {
            for (Class c : Class.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

