/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.Header;
import org.cip4.lib.xjdf.schema.Query;
import org.cip4.lib.xjdf.schema.ResourceQuParams;
import org.cip4.lib.xjdf.schema.Subscription;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QueryResource", propOrder={"resourceQuParams"})
@XmlRootElement(name="QueryResource")
public class QueryResource
extends Query
implements Serializable {
    @XmlElement(name="ResourceQuParams", required=true)
    protected ResourceQuParams resourceQuParams;
    @XmlAttribute(name="Languages")
    protected List<String> languages;

    public ResourceQuParams getResourceQuParams() {
        return this.resourceQuParams;
    }

    public void setResourceQuParams(ResourceQuParams value) {
        this.resourceQuParams = value;
    }

    public List<String> getLanguages() {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        return this.languages;
    }

    public QueryResource withResourceQuParams(ResourceQuParams value) {
        this.setResourceQuParams(value);
        return this;
    }

    public QueryResource withLanguages(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getLanguages().add(value);
            }
        }
        return this;
    }

    public QueryResource withLanguages(Collection<String> values) {
        if (values != null) {
            this.getLanguages().addAll(values);
        }
        return this;
    }

    @Override
    public QueryResource withSubscription(Subscription value) {
        this.setSubscription(value);
        return this;
    }

    @Override
    public QueryResource withHeader(Header value) {
        this.setHeader(value);
        return this;
    }

    @Override
    public QueryResource withAny(Object ... values) {
        if (values != null) {
            for (Object value : values) {
                this.getAny().add(value);
            }
        }
        return this;
    }

    @Override
    public QueryResource withAny(Collection<Object> values) {
        if (values != null) {
            this.getAny().addAll(values);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<String> rightLanguages;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        QueryResource that = (QueryResource)object;
        ResourceQuParams leftResourceQuParams = this.getResourceQuParams();
        ResourceQuParams rightResourceQuParams = that.getResourceQuParams();
        if (this.resourceQuParams != null) {
            if (that.resourceQuParams == null) return false;
            if (!leftResourceQuParams.equals(rightResourceQuParams)) {
                return false;
            }
        } else if (that.resourceQuParams != null) {
            return false;
        }
        List<String> leftLanguages = this.languages != null && !this.languages.isEmpty() ? this.getLanguages() : null;
        List<String> list = rightLanguages = that.languages != null && !that.languages.isEmpty() ? that.getLanguages() : null;
        if (this.languages != null && !this.languages.isEmpty()) {
            if (that.languages == null || that.languages.isEmpty()) return false;
            if (leftLanguages.equals(rightLanguages)) return true;
            return false;
        }
        if (that.languages == null || that.languages.isEmpty()) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<String> theLanguages;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        ResourceQuParams theResourceQuParams = this.getResourceQuParams();
        if (this.resourceQuParams != null) {
            currentHashCode += theResourceQuParams.hashCode();
        }
        currentHashCode *= 31;
        List<String> list = theLanguages = this.languages != null && !this.languages.isEmpty() ? this.getLanguages() : null;
        if (this.languages != null && !this.languages.isEmpty()) {
            currentHashCode += theLanguages.hashCode();
        }
        return currentHashCode;
    }
}

