/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="ScreenSelector")
public class ScreenSelector
implements Serializable {
    @XmlAttribute(name="Angle")
    protected Float angle;
    @XmlAttribute(name="DotSize")
    protected Float dotSize;
    @XmlAttribute(name="Frequency")
    protected Float frequency;
    @XmlAttribute(name="ScreeningFamily")
    protected String screeningFamily;
    @XmlAttribute(name="ScreeningType")
    protected ScreeningType screeningType;
    @XmlAttribute(name="Separation")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String separation;
    @XmlAttribute(name="SourceFrequencyMax")
    protected Float sourceFrequencyMax;
    @XmlAttribute(name="SourceFrequencyMin")
    protected Float sourceFrequencyMin;
    @XmlAttribute(name="SourceObjects")
    protected List<String> sourceObjects;
    @XmlAttribute(name="SpotFunction")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String spotFunction;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Float getAngle() {
        return this.angle;
    }

    public void setAngle(Float value) {
        this.angle = value;
    }

    public Float getDotSize() {
        return this.dotSize;
    }

    public void setDotSize(Float value) {
        this.dotSize = value;
    }

    public Float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Float value) {
        this.frequency = value;
    }

    public String getScreeningFamily() {
        return this.screeningFamily;
    }

    public void setScreeningFamily(String value) {
        this.screeningFamily = value;
    }

    public ScreeningType getScreeningType() {
        return this.screeningType;
    }

    public void setScreeningType(ScreeningType value) {
        this.screeningType = value;
    }

    public String getSeparation() {
        return this.separation;
    }

    public void setSeparation(String value) {
        this.separation = value;
    }

    public Float getSourceFrequencyMax() {
        return this.sourceFrequencyMax;
    }

    public void setSourceFrequencyMax(Float value) {
        this.sourceFrequencyMax = value;
    }

    public Float getSourceFrequencyMin() {
        return this.sourceFrequencyMin;
    }

    public void setSourceFrequencyMin(Float value) {
        this.sourceFrequencyMin = value;
    }

    public List<String> getSourceObjects() {
        if (this.sourceObjects == null) {
            this.sourceObjects = new ArrayList<String>();
        }
        return this.sourceObjects;
    }

    public String getSpotFunction() {
        return this.spotFunction;
    }

    public void setSpotFunction(String value) {
        this.spotFunction = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public ScreenSelector withAngle(Float value) {
        this.setAngle(value);
        return this;
    }

    public ScreenSelector withDotSize(Float value) {
        this.setDotSize(value);
        return this;
    }

    public ScreenSelector withFrequency(Float value) {
        this.setFrequency(value);
        return this;
    }

    public ScreenSelector withScreeningFamily(String value) {
        this.setScreeningFamily(value);
        return this;
    }

    public ScreenSelector withScreeningType(ScreeningType value) {
        this.setScreeningType(value);
        return this;
    }

    public ScreenSelector withSeparation(String value) {
        this.setSeparation(value);
        return this;
    }

    public ScreenSelector withSourceFrequencyMax(Float value) {
        this.setSourceFrequencyMax(value);
        return this;
    }

    public ScreenSelector withSourceFrequencyMin(Float value) {
        this.setSourceFrequencyMin(value);
        return this;
    }

    public ScreenSelector withSourceObjects(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getSourceObjects().add(value);
            }
        }
        return this;
    }

    public ScreenSelector withSourceObjects(Collection<String> values) {
        if (values != null) {
            this.getSourceObjects().addAll(values);
        }
        return this;
    }

    public ScreenSelector withSpotFunction(String value) {
        this.setSpotFunction(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<String> rightSourceObjects;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ScreenSelector that = (ScreenSelector)object;
        Float leftAngle = this.getAngle();
        Float rightAngle = that.getAngle();
        if (this.angle != null) {
            if (that.angle == null) return false;
            if (!leftAngle.equals(rightAngle)) {
                return false;
            }
        } else if (that.angle != null) {
            return false;
        }
        Float leftDotSize = this.getDotSize();
        Float rightDotSize = that.getDotSize();
        if (this.dotSize != null) {
            if (that.dotSize == null) return false;
            if (!leftDotSize.equals(rightDotSize)) {
                return false;
            }
        } else if (that.dotSize != null) {
            return false;
        }
        Float leftFrequency = this.getFrequency();
        Float rightFrequency = that.getFrequency();
        if (this.frequency != null) {
            if (that.frequency == null) return false;
            if (!leftFrequency.equals(rightFrequency)) {
                return false;
            }
        } else if (that.frequency != null) {
            return false;
        }
        String leftScreeningFamily = this.getScreeningFamily();
        String rightScreeningFamily = that.getScreeningFamily();
        if (this.screeningFamily != null) {
            if (that.screeningFamily == null) return false;
            if (!leftScreeningFamily.equals(rightScreeningFamily)) {
                return false;
            }
        } else if (that.screeningFamily != null) {
            return false;
        }
        ScreeningType leftScreeningType = this.getScreeningType();
        ScreeningType rightScreeningType = that.getScreeningType();
        if (this.screeningType != null) {
            if (that.screeningType == null) return false;
            if (!leftScreeningType.equals((Object)rightScreeningType)) {
                return false;
            }
        } else if (that.screeningType != null) {
            return false;
        }
        String leftSeparation = this.getSeparation();
        String rightSeparation = that.getSeparation();
        if (this.separation != null) {
            if (that.separation == null) return false;
            if (!leftSeparation.equals(rightSeparation)) {
                return false;
            }
        } else if (that.separation != null) {
            return false;
        }
        Float leftSourceFrequencyMax = this.getSourceFrequencyMax();
        Float rightSourceFrequencyMax = that.getSourceFrequencyMax();
        if (this.sourceFrequencyMax != null) {
            if (that.sourceFrequencyMax == null) return false;
            if (!leftSourceFrequencyMax.equals(rightSourceFrequencyMax)) {
                return false;
            }
        } else if (that.sourceFrequencyMax != null) {
            return false;
        }
        Float leftSourceFrequencyMin = this.getSourceFrequencyMin();
        Float rightSourceFrequencyMin = that.getSourceFrequencyMin();
        if (this.sourceFrequencyMin != null) {
            if (that.sourceFrequencyMin == null) return false;
            if (!leftSourceFrequencyMin.equals(rightSourceFrequencyMin)) {
                return false;
            }
        } else if (that.sourceFrequencyMin != null) {
            return false;
        }
        List<String> leftSourceObjects = this.sourceObjects != null && !this.sourceObjects.isEmpty() ? this.getSourceObjects() : null;
        List<String> list = rightSourceObjects = that.sourceObjects != null && !that.sourceObjects.isEmpty() ? that.getSourceObjects() : null;
        if (this.sourceObjects != null && !this.sourceObjects.isEmpty()) {
            if (that.sourceObjects == null || that.sourceObjects.isEmpty()) return false;
            if (!leftSourceObjects.equals(rightSourceObjects)) {
                return false;
            }
        } else if (that.sourceObjects != null && !that.sourceObjects.isEmpty()) {
            return false;
        }
        String leftSpotFunction = this.getSpotFunction();
        String rightSpotFunction = that.getSpotFunction();
        if (this.spotFunction != null) {
            if (that.spotFunction == null) return false;
            if (leftSpotFunction.equals(rightSpotFunction)) return true;
            return false;
        }
        if (that.spotFunction == null) return true;
        return false;
    }

    public int hashCode() {
        List<String> theSourceObjects;
        int currentHashCode = 1;
        currentHashCode *= 31;
        Float theAngle = this.getAngle();
        if (this.angle != null) {
            currentHashCode += theAngle.hashCode();
        }
        currentHashCode *= 31;
        Float theDotSize = this.getDotSize();
        if (this.dotSize != null) {
            currentHashCode += theDotSize.hashCode();
        }
        currentHashCode *= 31;
        Float theFrequency = this.getFrequency();
        if (this.frequency != null) {
            currentHashCode += theFrequency.hashCode();
        }
        currentHashCode *= 31;
        String theScreeningFamily = this.getScreeningFamily();
        if (this.screeningFamily != null) {
            currentHashCode += theScreeningFamily.hashCode();
        }
        currentHashCode *= 31;
        ScreeningType theScreeningType = this.getScreeningType();
        if (this.screeningType != null) {
            currentHashCode += theScreeningType.hashCode();
        }
        currentHashCode *= 31;
        String theSeparation = this.getSeparation();
        if (this.separation != null) {
            currentHashCode += theSeparation.hashCode();
        }
        currentHashCode *= 31;
        Float theSourceFrequencyMax = this.getSourceFrequencyMax();
        if (this.sourceFrequencyMax != null) {
            currentHashCode += theSourceFrequencyMax.hashCode();
        }
        currentHashCode *= 31;
        Float theSourceFrequencyMin = this.getSourceFrequencyMin();
        if (this.sourceFrequencyMin != null) {
            currentHashCode += theSourceFrequencyMin.hashCode();
        }
        currentHashCode *= 31;
        List<String> list = theSourceObjects = this.sourceObjects != null && !this.sourceObjects.isEmpty() ? this.getSourceObjects() : null;
        if (this.sourceObjects != null && !this.sourceObjects.isEmpty()) {
            currentHashCode += theSourceObjects.hashCode();
        }
        currentHashCode *= 31;
        String theSpotFunction = this.getSpotFunction();
        if (this.spotFunction != null) {
            currentHashCode += theSpotFunction.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ScreeningType {
        ADAPTIVE("Adaptive"),
        AM("AM"),
        ERROR_DIFFUSION("ErrorDiffusion"),
        FM("FM"),
        HYBRID_AM_FM("HybridAM-FM"),
        HYBRID_A_MLINE_DOT("HybridAMline-dot");

        private final String value;

        private ScreeningType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ScreeningType fromValue(String v) {
            for (ScreeningType c : ScreeningType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

