/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.Intent;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.ProductIntent;
import org.cip4.lib.xjdf.schema.SpecificResource;

public class FinalProduct {
    private final String ROOT_PRODUCT = "ROOT_PRODUCT";
    private final Map<String, Product> productParts = new LinkedHashMap<String, Product>();

    public FinalProduct() {
        this((Integer)null, (String)null);
    }

    public FinalProduct(Integer amount, String descriptiveName) {
        this.productParts.put("ROOT_PRODUCT", new Product());
        this.productParts.get("ROOT_PRODUCT").withAmount(amount).withDescriptiveName(descriptiveName).setIsRoot(true);
    }

    public FinalProduct(Product rootProductPart, List<Product> allProductParts) {
        this.productParts.put("ROOT_PRODUCT", rootProductPart);
    }

    public Product getProduct() {
        return this.productParts.get("ROOT_PRODUCT");
    }

    public String getDescriptiveName() {
        return this.getProduct().getDescriptiveName();
    }

    public void setDescriptiveName(String descriptiveName) {
        this.getProduct().setDescriptiveName(descriptiveName);
    }

    public Integer getAmount() {
        return this.getProduct().getAmount();
    }

    public void setAmount(Integer amount) {
        this.getProduct().setAmount(amount);
    }

    public String getId() {
        return this.getProduct().getID();
    }

    public void setId(String id) {
        this.getProduct().setID(id);
    }

    public void addIntents(ProductIntent ... productIntents) {
        for (ProductIntent productIntent : productIntents) {
            this.addIntent(productIntent);
        }
    }

    public Intent addIntent(ProductIntent productIntent) {
        String paramName = productIntent.getClass().getSimpleName();
        QName qname = new QName("http://www.CIP4.org/JDFSchema_2_0", paramName);
        JAXBElement productIntentJaxB = new JAXBElement(qname, SpecificResource.class, null, (Object)productIntent);
        Intent intent = new Intent().withName(paramName).withProductIntent((JAXBElement<? extends ProductIntent>)productIntentJaxB);
        this.productParts.get("ROOT_PRODUCT").getIntent().add(intent);
        this.productParts.get("ROOT_PRODUCT").getIntent().sort(Comparator.comparing(Intent::getName));
        return intent;
    }

    public <T extends ProductIntent> Intent getIntent(Class<T> productIntentType) {
        for (Intent intent : this.productParts.get("ROOT_PRODUCT").getIntent()) {
            if (((ProductIntent)intent.getProductIntent().getValue()).getClass() != productIntentType) continue;
            return intent;
        }
        return null;
    }

    public List<Intent> getIntents() {
        return this.getProduct().getIntent();
    }

    public <T extends ProductIntent> T getProductIntent(Class<T> productIntentType) {
        Intent intent = this.getIntent(productIntentType);
        return (T)(intent == null ? null : (ProductIntent)intent.getProductIntent().getValue());
    }

    public List<Class<?>> getProductIntentTypes() {
        ArrayList classes = new ArrayList();
        for (Intent intent : this.productParts.get("ROOT_PRODUCT").getIntent()) {
            classes.add(((ProductIntent)intent.getProductIntent().getValue()).getClass());
        }
        return classes;
    }

    public List<Product> getProductParts() {
        return new ArrayList<Product>(this.productParts.values());
    }
}

