/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.HexBinaryAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.Disposition;
import org.cip4.lib.xjdf.schema.NetworkHeader;
import org.cip4.lib.xjdf.type.URI;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"disposition", "networkHeader"})
@XmlRootElement(name="FileSpec")
public class FileSpec
implements Serializable {
    @XmlElement(name="Disposition")
    protected Disposition disposition;
    @XmlElement(name="NetworkHeader")
    protected List<NetworkHeader> networkHeader;
    @XmlAttribute(name="CheckSum")
    @XmlJavaTypeAdapter(value=HexBinaryAdapter.class)
    @XmlSchemaType(name="hexBinary")
    protected byte[] checkSum;
    @XmlAttribute(name="Encoding")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String encoding;
    @XmlAttribute(name="FileFormat")
    protected String fileFormat;
    @XmlAttribute(name="FileSize")
    protected Long fileSize;
    @XmlAttribute(name="FileTemplate")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> fileTemplate;
    @XmlAttribute(name="MimeType")
    protected String mimeType;
    @XmlAttribute(name="NPage")
    protected Integer nPage;
    @XmlAttribute(name="OverwritePolicy")
    protected OverwritePolicy overwritePolicy;
    @XmlAttribute(name="Password")
    protected String password;
    @XmlAttribute(name="ResourceUsage")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String resourceUsage;
    @XmlAttribute(name="SearchDepth")
    protected Integer searchDepth;
    @XmlAttribute(name="UID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String uid;
    @XmlAttribute(name="URL")
    @XmlJavaTypeAdapter(value=URI.class)
    protected URI url;
    @XmlAttribute(name="UserFileName")
    protected String userFileName;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Disposition getDisposition() {
        return this.disposition;
    }

    public void setDisposition(Disposition value) {
        this.disposition = value;
    }

    public List<NetworkHeader> getNetworkHeader() {
        if (this.networkHeader == null) {
            this.networkHeader = new ArrayList<NetworkHeader>();
        }
        return this.networkHeader;
    }

    public byte[] getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(byte[] value) {
        this.checkSum = value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String value) {
        this.fileFormat = value;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long value) {
        this.fileSize = value;
    }

    public List<String> getFileTemplate() {
        if (this.fileTemplate == null) {
            this.fileTemplate = new ArrayList<String>();
        }
        return this.fileTemplate;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String value) {
        this.mimeType = value;
    }

    public Integer getNPage() {
        return this.nPage;
    }

    public void setNPage(Integer value) {
        this.nPage = value;
    }

    public OverwritePolicy getOverwritePolicy() {
        return this.overwritePolicy;
    }

    public void setOverwritePolicy(OverwritePolicy value) {
        this.overwritePolicy = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getResourceUsage() {
        return this.resourceUsage;
    }

    public void setResourceUsage(String value) {
        this.resourceUsage = value;
    }

    public Integer getSearchDepth() {
        return this.searchDepth;
    }

    public void setSearchDepth(Integer value) {
        this.searchDepth = value;
    }

    public String getUID() {
        return this.uid;
    }

    public void setUID(String value) {
        this.uid = value;
    }

    public URI getURL() {
        return this.url;
    }

    public void setURL(URI value) {
        this.url = value;
    }

    public String getUserFileName() {
        return this.userFileName;
    }

    public void setUserFileName(String value) {
        this.userFileName = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public FileSpec withDisposition(Disposition value) {
        this.setDisposition(value);
        return this;
    }

    public FileSpec withNetworkHeader(NetworkHeader ... values) {
        if (values != null) {
            for (NetworkHeader value : values) {
                this.getNetworkHeader().add(value);
            }
        }
        return this;
    }

    public FileSpec withNetworkHeader(Collection<NetworkHeader> values) {
        if (values != null) {
            this.getNetworkHeader().addAll(values);
        }
        return this;
    }

    public FileSpec withCheckSum(byte[] value) {
        this.setCheckSum(value);
        return this;
    }

    public FileSpec withEncoding(String value) {
        this.setEncoding(value);
        return this;
    }

    public FileSpec withFileFormat(String value) {
        this.setFileFormat(value);
        return this;
    }

    public FileSpec withFileSize(Long value) {
        this.setFileSize(value);
        return this;
    }

    public FileSpec withFileTemplate(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getFileTemplate().add(value);
            }
        }
        return this;
    }

    public FileSpec withFileTemplate(Collection<String> values) {
        if (values != null) {
            this.getFileTemplate().addAll(values);
        }
        return this;
    }

    public FileSpec withMimeType(String value) {
        this.setMimeType(value);
        return this;
    }

    public FileSpec withNPage(Integer value) {
        this.setNPage(value);
        return this;
    }

    public FileSpec withOverwritePolicy(OverwritePolicy value) {
        this.setOverwritePolicy(value);
        return this;
    }

    public FileSpec withPassword(String value) {
        this.setPassword(value);
        return this;
    }

    public FileSpec withResourceUsage(String value) {
        this.setResourceUsage(value);
        return this;
    }

    public FileSpec withSearchDepth(Integer value) {
        this.setSearchDepth(value);
        return this;
    }

    public FileSpec withUID(String value) {
        this.setUID(value);
        return this;
    }

    public FileSpec withURL(URI value) {
        this.setURL(value);
        return this;
    }

    public FileSpec withUserFileName(String value) {
        this.setUserFileName(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<String> rightFileTemplate;
        List<NetworkHeader> rightNetworkHeader;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        FileSpec that = (FileSpec)object;
        Disposition leftDisposition = this.getDisposition();
        Disposition rightDisposition = that.getDisposition();
        if (this.disposition != null) {
            if (that.disposition == null) return false;
            if (!leftDisposition.equals(rightDisposition)) {
                return false;
            }
        } else if (that.disposition != null) {
            return false;
        }
        List<NetworkHeader> leftNetworkHeader = this.networkHeader != null && !this.networkHeader.isEmpty() ? this.getNetworkHeader() : null;
        List<NetworkHeader> list = rightNetworkHeader = that.networkHeader != null && !that.networkHeader.isEmpty() ? that.getNetworkHeader() : null;
        if (this.networkHeader != null && !this.networkHeader.isEmpty()) {
            if (that.networkHeader == null || that.networkHeader.isEmpty()) return false;
            if (!leftNetworkHeader.equals(rightNetworkHeader)) {
                return false;
            }
        } else if (that.networkHeader != null && !that.networkHeader.isEmpty()) {
            return false;
        }
        byte[] leftCheckSum = this.getCheckSum();
        byte[] rightCheckSum = that.getCheckSum();
        if (this.checkSum != null) {
            if (that.checkSum == null) return false;
            if (!Arrays.equals(leftCheckSum, rightCheckSum)) {
                return false;
            }
        } else if (that.checkSum != null) {
            return false;
        }
        String leftEncoding = this.getEncoding();
        String rightEncoding = that.getEncoding();
        if (this.encoding != null) {
            if (that.encoding == null) return false;
            if (!leftEncoding.equals(rightEncoding)) {
                return false;
            }
        } else if (that.encoding != null) {
            return false;
        }
        String leftFileFormat = this.getFileFormat();
        String rightFileFormat = that.getFileFormat();
        if (this.fileFormat != null) {
            if (that.fileFormat == null) return false;
            if (!leftFileFormat.equals(rightFileFormat)) {
                return false;
            }
        } else if (that.fileFormat != null) {
            return false;
        }
        Long leftFileSize = this.getFileSize();
        Long rightFileSize = that.getFileSize();
        if (this.fileSize != null) {
            if (that.fileSize == null) return false;
            if (!leftFileSize.equals(rightFileSize)) {
                return false;
            }
        } else if (that.fileSize != null) {
            return false;
        }
        List<String> leftFileTemplate = this.fileTemplate != null && !this.fileTemplate.isEmpty() ? this.getFileTemplate() : null;
        List<String> list2 = rightFileTemplate = that.fileTemplate != null && !that.fileTemplate.isEmpty() ? that.getFileTemplate() : null;
        if (this.fileTemplate != null && !this.fileTemplate.isEmpty()) {
            if (that.fileTemplate == null || that.fileTemplate.isEmpty()) return false;
            if (!leftFileTemplate.equals(rightFileTemplate)) {
                return false;
            }
        } else if (that.fileTemplate != null && !that.fileTemplate.isEmpty()) {
            return false;
        }
        String leftMimeType = this.getMimeType();
        String rightMimeType = that.getMimeType();
        if (this.mimeType != null) {
            if (that.mimeType == null) return false;
            if (!leftMimeType.equals(rightMimeType)) {
                return false;
            }
        } else if (that.mimeType != null) {
            return false;
        }
        Integer leftNPage = this.getNPage();
        Integer rightNPage = that.getNPage();
        if (this.nPage != null) {
            if (that.nPage == null) return false;
            if (!leftNPage.equals(rightNPage)) {
                return false;
            }
        } else if (that.nPage != null) {
            return false;
        }
        OverwritePolicy leftOverwritePolicy = this.getOverwritePolicy();
        OverwritePolicy rightOverwritePolicy = that.getOverwritePolicy();
        if (this.overwritePolicy != null) {
            if (that.overwritePolicy == null) return false;
            if (!leftOverwritePolicy.equals((Object)rightOverwritePolicy)) {
                return false;
            }
        } else if (that.overwritePolicy != null) {
            return false;
        }
        String leftPassword = this.getPassword();
        String rightPassword = that.getPassword();
        if (this.password != null) {
            if (that.password == null) return false;
            if (!leftPassword.equals(rightPassword)) {
                return false;
            }
        } else if (that.password != null) {
            return false;
        }
        String leftResourceUsage = this.getResourceUsage();
        String rightResourceUsage = that.getResourceUsage();
        if (this.resourceUsage != null) {
            if (that.resourceUsage == null) return false;
            if (!leftResourceUsage.equals(rightResourceUsage)) {
                return false;
            }
        } else if (that.resourceUsage != null) {
            return false;
        }
        Integer leftSearchDepth = this.getSearchDepth();
        Integer rightSearchDepth = that.getSearchDepth();
        if (this.searchDepth != null) {
            if (that.searchDepth == null) return false;
            if (!leftSearchDepth.equals(rightSearchDepth)) {
                return false;
            }
        } else if (that.searchDepth != null) {
            return false;
        }
        String leftUID = this.getUID();
        String rightUID = that.getUID();
        if (this.uid != null) {
            if (that.uid == null) return false;
            if (!leftUID.equals(rightUID)) {
                return false;
            }
        } else if (that.uid != null) {
            return false;
        }
        URI leftURL = this.getURL();
        URI rightURL = that.getURL();
        if (this.url != null) {
            if (that.url == null) return false;
            if (!leftURL.equals((Object)rightURL)) {
                return false;
            }
        } else if (that.url != null) {
            return false;
        }
        String leftUserFileName = this.getUserFileName();
        String rightUserFileName = that.getUserFileName();
        if (this.userFileName != null) {
            if (that.userFileName == null) return false;
            if (leftUserFileName.equals(rightUserFileName)) return true;
            return false;
        }
        if (that.userFileName == null) return true;
        return false;
    }

    public int hashCode() {
        List<String> theFileTemplate;
        List<NetworkHeader> theNetworkHeader;
        int currentHashCode = 1;
        currentHashCode *= 31;
        Disposition theDisposition = this.getDisposition();
        if (this.disposition != null) {
            currentHashCode += theDisposition.hashCode();
        }
        currentHashCode *= 31;
        List<NetworkHeader> list = theNetworkHeader = this.networkHeader != null && !this.networkHeader.isEmpty() ? this.getNetworkHeader() : null;
        if (this.networkHeader != null && !this.networkHeader.isEmpty()) {
            currentHashCode += theNetworkHeader.hashCode();
        }
        currentHashCode *= 31;
        byte[] theCheckSum = this.getCheckSum();
        currentHashCode += Arrays.hashCode(theCheckSum);
        currentHashCode *= 31;
        String theEncoding = this.getEncoding();
        if (this.encoding != null) {
            currentHashCode += theEncoding.hashCode();
        }
        currentHashCode *= 31;
        String theFileFormat = this.getFileFormat();
        if (this.fileFormat != null) {
            currentHashCode += theFileFormat.hashCode();
        }
        currentHashCode *= 31;
        Long theFileSize = this.getFileSize();
        if (this.fileSize != null) {
            currentHashCode += theFileSize.hashCode();
        }
        currentHashCode *= 31;
        List<String> list2 = theFileTemplate = this.fileTemplate != null && !this.fileTemplate.isEmpty() ? this.getFileTemplate() : null;
        if (this.fileTemplate != null && !this.fileTemplate.isEmpty()) {
            currentHashCode += theFileTemplate.hashCode();
        }
        currentHashCode *= 31;
        String theMimeType = this.getMimeType();
        if (this.mimeType != null) {
            currentHashCode += theMimeType.hashCode();
        }
        currentHashCode *= 31;
        Integer theNPage = this.getNPage();
        if (this.nPage != null) {
            currentHashCode += theNPage.hashCode();
        }
        currentHashCode *= 31;
        OverwritePolicy theOverwritePolicy = this.getOverwritePolicy();
        if (this.overwritePolicy != null) {
            currentHashCode += theOverwritePolicy.hashCode();
        }
        currentHashCode *= 31;
        String thePassword = this.getPassword();
        if (this.password != null) {
            currentHashCode += thePassword.hashCode();
        }
        currentHashCode *= 31;
        String theResourceUsage = this.getResourceUsage();
        if (this.resourceUsage != null) {
            currentHashCode += theResourceUsage.hashCode();
        }
        currentHashCode *= 31;
        Integer theSearchDepth = this.getSearchDepth();
        if (this.searchDepth != null) {
            currentHashCode += theSearchDepth.hashCode();
        }
        currentHashCode *= 31;
        String theUID = this.getUID();
        if (this.uid != null) {
            currentHashCode += theUID.hashCode();
        }
        currentHashCode *= 31;
        URI theURL = this.getURL();
        if (this.url != null) {
            currentHashCode += theURL.hashCode();
        }
        currentHashCode *= 31;
        String theUserFileName = this.getUserFileName();
        if (this.userFileName != null) {
            currentHashCode += theUserFileName.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum OverwritePolicy {
        OVERWRITE("Overwrite"),
        RENAME_NEW("RenameNew"),
        RENAME_OLD("RenameOld"),
        NEW_VERSION("NewVersion"),
        OPERATOR_INTERVENTION("OperatorIntervention"),
        ABORT("Abort");

        private final String value;

        private OverwritePolicy(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static OverwritePolicy fromValue(String v) {
            for (OverwritePolicy c : OverwritePolicy.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

