/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.type.Matrix;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Preview", propOrder={"fileSpec"})
@XmlRootElement(name="Preview")
public class Preview
extends SpecificResource
implements Serializable {
    @XmlElement(name="FileSpec")
    protected FileSpec fileSpec;
    @XmlAttribute(name="Compensation")
    protected Compensation compensation;
    @XmlAttribute(name="CTM")
    @XmlJavaTypeAdapter(value=Matrix.class)
    protected Matrix ctm;
    @XmlAttribute(name="PreviewFileType")
    protected PreviewFileType previewFileType;

    public FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(FileSpec value) {
        this.fileSpec = value;
    }

    public Compensation getCompensation() {
        return this.compensation;
    }

    public void setCompensation(Compensation value) {
        this.compensation = value;
    }

    public Matrix getCTM() {
        return this.ctm;
    }

    public void setCTM(Matrix value) {
        this.ctm = value;
    }

    public PreviewFileType getPreviewFileType() {
        return this.previewFileType;
    }

    public void setPreviewFileType(PreviewFileType value) {
        this.previewFileType = value;
    }

    public Preview withFileSpec(FileSpec value) {
        this.setFileSpec(value);
        return this;
    }

    public Preview withCompensation(Compensation value) {
        this.setCompensation(value);
        return this;
    }

    public Preview withCTM(Matrix value) {
        this.setCTM(value);
        return this;
    }

    public Preview withPreviewFileType(PreviewFileType value) {
        this.setPreviewFileType(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Preview that = (Preview)object;
        FileSpec leftFileSpec = this.getFileSpec();
        FileSpec rightFileSpec = that.getFileSpec();
        if (this.fileSpec != null) {
            if (that.fileSpec == null) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null) {
            return false;
        }
        Compensation leftCompensation = this.getCompensation();
        Compensation rightCompensation = that.getCompensation();
        if (this.compensation != null) {
            if (that.compensation == null) return false;
            if (!leftCompensation.equals((Object)rightCompensation)) {
                return false;
            }
        } else if (that.compensation != null) {
            return false;
        }
        Matrix leftCTM = this.getCTM();
        Matrix rightCTM = that.getCTM();
        if (this.ctm != null) {
            if (that.ctm == null) return false;
            if (!leftCTM.equals((Object)rightCTM)) {
                return false;
            }
        } else if (that.ctm != null) {
            return false;
        }
        PreviewFileType leftPreviewFileType = this.getPreviewFileType();
        PreviewFileType rightPreviewFileType = that.getPreviewFileType();
        if (this.previewFileType != null) {
            if (that.previewFileType == null) return false;
            if (leftPreviewFileType.equals((Object)rightPreviewFileType)) return true;
            return false;
        }
        if (that.previewFileType == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        FileSpec theFileSpec = this.getFileSpec();
        if (this.fileSpec != null) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        Compensation theCompensation = this.getCompensation();
        if (this.compensation != null) {
            currentHashCode += theCompensation.hashCode();
        }
        currentHashCode *= 31;
        Matrix theCTM = this.getCTM();
        if (this.ctm != null) {
            currentHashCode += theCTM.hashCode();
        }
        currentHashCode *= 31;
        PreviewFileType thePreviewFileType = this.getPreviewFileType();
        if (this.previewFileType != null) {
            currentHashCode += thePreviewFileType.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Compensation {
        NONE("None"),
        FILM("Film"),
        PLATE("Plate"),
        PRESS("Press");

        private final String value;

        private Compensation(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Compensation fromValue(String v) {
            for (Compensation c : Compensation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum PreviewFileType {
        PNG("PNG"),
        CIP_3_MULTIPLE("CIP3Multiple"),
        CIP_3_SINGLE("CIP3Single");

        private final String value;

        private PreviewFileType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static PreviewFileType fromValue(String v) {
            for (PreviewFileType c : PreviewFileType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

