/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.schema.StapleShape;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="StitchingParams", propOrder={"fileSpec"})
@XmlRootElement(name="StitchingParams")
public class StitchingParams
extends SpecificResource
implements Serializable {
    @XmlElement(name="FileSpec")
    protected FileSpec fileSpec;
    @XmlAttribute(name="Angle")
    protected Float angle;
    @XmlAttribute(name="NumberOfStitches")
    protected Integer numberOfStitches;
    @XmlAttribute(name="Offset")
    protected Float offset;
    @XmlAttribute(name="StapleShape")
    protected StapleShape stapleShape;
    @XmlAttribute(name="StitchOrigin")
    protected StitchOrigin stitchOrigin;
    @XmlAttribute(name="StitchPositions")
    protected List<Float> stitchPositions;
    @XmlAttribute(name="StitchType")
    protected StitchType stitchType;
    @XmlAttribute(name="StitchWidth")
    protected Float stitchWidth;
    @XmlAttribute(name="TightBacking")
    protected TightBacking tightBacking;
    @XmlAttribute(name="WireGauge")
    protected Float wireGauge;

    public FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(FileSpec value) {
        this.fileSpec = value;
    }

    public Float getAngle() {
        return this.angle;
    }

    public void setAngle(Float value) {
        this.angle = value;
    }

    public Integer getNumberOfStitches() {
        return this.numberOfStitches;
    }

    public void setNumberOfStitches(Integer value) {
        this.numberOfStitches = value;
    }

    public Float getOffset() {
        return this.offset;
    }

    public void setOffset(Float value) {
        this.offset = value;
    }

    public StapleShape getStapleShape() {
        return this.stapleShape;
    }

    public void setStapleShape(StapleShape value) {
        this.stapleShape = value;
    }

    public StitchOrigin getStitchOrigin() {
        return this.stitchOrigin;
    }

    public void setStitchOrigin(StitchOrigin value) {
        this.stitchOrigin = value;
    }

    public List<Float> getStitchPositions() {
        if (this.stitchPositions == null) {
            this.stitchPositions = new ArrayList<Float>();
        }
        return this.stitchPositions;
    }

    public StitchType getStitchType() {
        return this.stitchType;
    }

    public void setStitchType(StitchType value) {
        this.stitchType = value;
    }

    public Float getStitchWidth() {
        return this.stitchWidth;
    }

    public void setStitchWidth(Float value) {
        this.stitchWidth = value;
    }

    public TightBacking getTightBacking() {
        return this.tightBacking;
    }

    public void setTightBacking(TightBacking value) {
        this.tightBacking = value;
    }

    public Float getWireGauge() {
        return this.wireGauge;
    }

    public void setWireGauge(Float value) {
        this.wireGauge = value;
    }

    public StitchingParams withFileSpec(FileSpec value) {
        this.setFileSpec(value);
        return this;
    }

    public StitchingParams withAngle(Float value) {
        this.setAngle(value);
        return this;
    }

    public StitchingParams withNumberOfStitches(Integer value) {
        this.setNumberOfStitches(value);
        return this;
    }

    public StitchingParams withOffset(Float value) {
        this.setOffset(value);
        return this;
    }

    public StitchingParams withStapleShape(StapleShape value) {
        this.setStapleShape(value);
        return this;
    }

    public StitchingParams withStitchOrigin(StitchOrigin value) {
        this.setStitchOrigin(value);
        return this;
    }

    public StitchingParams withStitchPositions(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getStitchPositions().add(value);
            }
        }
        return this;
    }

    public StitchingParams withStitchPositions(Collection<Float> values) {
        if (values != null) {
            this.getStitchPositions().addAll(values);
        }
        return this;
    }

    public StitchingParams withStitchType(StitchType value) {
        this.setStitchType(value);
        return this;
    }

    public StitchingParams withStitchWidth(Float value) {
        this.setStitchWidth(value);
        return this;
    }

    public StitchingParams withTightBacking(TightBacking value) {
        this.setTightBacking(value);
        return this;
    }

    public StitchingParams withWireGauge(Float value) {
        this.setWireGauge(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Float> rightStitchPositions;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        StitchingParams that = (StitchingParams)object;
        FileSpec leftFileSpec = this.getFileSpec();
        FileSpec rightFileSpec = that.getFileSpec();
        if (this.fileSpec != null) {
            if (that.fileSpec == null) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null) {
            return false;
        }
        Float leftAngle = this.getAngle();
        Float rightAngle = that.getAngle();
        if (this.angle != null) {
            if (that.angle == null) return false;
            if (!leftAngle.equals(rightAngle)) {
                return false;
            }
        } else if (that.angle != null) {
            return false;
        }
        Integer leftNumberOfStitches = this.getNumberOfStitches();
        Integer rightNumberOfStitches = that.getNumberOfStitches();
        if (this.numberOfStitches != null) {
            if (that.numberOfStitches == null) return false;
            if (!leftNumberOfStitches.equals(rightNumberOfStitches)) {
                return false;
            }
        } else if (that.numberOfStitches != null) {
            return false;
        }
        Float leftOffset = this.getOffset();
        Float rightOffset = that.getOffset();
        if (this.offset != null) {
            if (that.offset == null) return false;
            if (!leftOffset.equals(rightOffset)) {
                return false;
            }
        } else if (that.offset != null) {
            return false;
        }
        StapleShape leftStapleShape = this.getStapleShape();
        StapleShape rightStapleShape = that.getStapleShape();
        if (this.stapleShape != null) {
            if (that.stapleShape == null) return false;
            if (!leftStapleShape.equals((Object)rightStapleShape)) {
                return false;
            }
        } else if (that.stapleShape != null) {
            return false;
        }
        StitchOrigin leftStitchOrigin = this.getStitchOrigin();
        StitchOrigin rightStitchOrigin = that.getStitchOrigin();
        if (this.stitchOrigin != null) {
            if (that.stitchOrigin == null) return false;
            if (!leftStitchOrigin.equals((Object)rightStitchOrigin)) {
                return false;
            }
        } else if (that.stitchOrigin != null) {
            return false;
        }
        List<Float> leftStitchPositions = this.stitchPositions != null && !this.stitchPositions.isEmpty() ? this.getStitchPositions() : null;
        List<Float> list = rightStitchPositions = that.stitchPositions != null && !that.stitchPositions.isEmpty() ? that.getStitchPositions() : null;
        if (this.stitchPositions != null && !this.stitchPositions.isEmpty()) {
            if (that.stitchPositions == null || that.stitchPositions.isEmpty()) return false;
            if (!leftStitchPositions.equals(rightStitchPositions)) {
                return false;
            }
        } else if (that.stitchPositions != null && !that.stitchPositions.isEmpty()) {
            return false;
        }
        StitchType leftStitchType = this.getStitchType();
        StitchType rightStitchType = that.getStitchType();
        if (this.stitchType != null) {
            if (that.stitchType == null) return false;
            if (!leftStitchType.equals((Object)rightStitchType)) {
                return false;
            }
        } else if (that.stitchType != null) {
            return false;
        }
        Float leftStitchWidth = this.getStitchWidth();
        Float rightStitchWidth = that.getStitchWidth();
        if (this.stitchWidth != null) {
            if (that.stitchWidth == null) return false;
            if (!leftStitchWidth.equals(rightStitchWidth)) {
                return false;
            }
        } else if (that.stitchWidth != null) {
            return false;
        }
        TightBacking leftTightBacking = this.getTightBacking();
        TightBacking rightTightBacking = that.getTightBacking();
        if (this.tightBacking != null) {
            if (that.tightBacking == null) return false;
            if (!leftTightBacking.equals((Object)rightTightBacking)) {
                return false;
            }
        } else if (that.tightBacking != null) {
            return false;
        }
        Float leftWireGauge = this.getWireGauge();
        Float rightWireGauge = that.getWireGauge();
        if (this.wireGauge != null) {
            if (that.wireGauge == null) return false;
            if (leftWireGauge.equals(rightWireGauge)) return true;
            return false;
        }
        if (that.wireGauge == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Float> theStitchPositions;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        FileSpec theFileSpec = this.getFileSpec();
        if (this.fileSpec != null) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        Float theAngle = this.getAngle();
        if (this.angle != null) {
            currentHashCode += theAngle.hashCode();
        }
        currentHashCode *= 31;
        Integer theNumberOfStitches = this.getNumberOfStitches();
        if (this.numberOfStitches != null) {
            currentHashCode += theNumberOfStitches.hashCode();
        }
        currentHashCode *= 31;
        Float theOffset = this.getOffset();
        if (this.offset != null) {
            currentHashCode += theOffset.hashCode();
        }
        currentHashCode *= 31;
        StapleShape theStapleShape = this.getStapleShape();
        if (this.stapleShape != null) {
            currentHashCode += theStapleShape.hashCode();
        }
        currentHashCode *= 31;
        StitchOrigin theStitchOrigin = this.getStitchOrigin();
        if (this.stitchOrigin != null) {
            currentHashCode += theStitchOrigin.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list = theStitchPositions = this.stitchPositions != null && !this.stitchPositions.isEmpty() ? this.getStitchPositions() : null;
        if (this.stitchPositions != null && !this.stitchPositions.isEmpty()) {
            currentHashCode += theStitchPositions.hashCode();
        }
        currentHashCode *= 31;
        StitchType theStitchType = this.getStitchType();
        if (this.stitchType != null) {
            currentHashCode += theStitchType.hashCode();
        }
        currentHashCode *= 31;
        Float theStitchWidth = this.getStitchWidth();
        if (this.stitchWidth != null) {
            currentHashCode += theStitchWidth.hashCode();
        }
        currentHashCode *= 31;
        TightBacking theTightBacking = this.getTightBacking();
        if (this.tightBacking != null) {
            currentHashCode += theTightBacking.hashCode();
        }
        currentHashCode *= 31;
        Float theWireGauge = this.getWireGauge();
        if (this.wireGauge != null) {
            currentHashCode += theWireGauge.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum StitchOrigin {
        TRIM_BOX_CENTER("TrimBoxCenter"),
        TRIM_BOX_JOG_SIDE("TrimBoxJogSide"),
        UNTRIMMED_JOG_SIDE("UntrimmedJogSide");

        private final String value;

        private StitchOrigin(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static StitchOrigin fromValue(String v) {
            for (StitchOrigin c : StitchOrigin.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum StitchType {
        CORNER("Corner"),
        SADDLE("Saddle"),
        SIDE("Side");

        private final String value;

        private StitchType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static StitchType fromValue(String v) {
            for (StitchType c : StitchType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum TightBacking {
        ROUND("Round"),
        ROUND_BACKED("RoundBacked"),
        FLAT("Flat"),
        FLAT_BACKED("FlatBacked");

        private final String value;

        private TightBacking(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static TightBacking fromValue(String v) {
            for (TightBacking c : TightBacking.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

