/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ThreadSealingParams")
@XmlRootElement(name="ThreadSealingParams")
public class ThreadSealingParams
extends SpecificResource
implements Serializable {
    @XmlAttribute(name="BlindStitch")
    protected Boolean blindStitch;
    @XmlAttribute(name="ThreadLength")
    protected Float threadLength;
    @XmlAttribute(name="ThreadPositions")
    protected List<Float> threadPositions;
    @XmlAttribute(name="ThreadStitchWidth")
    protected Float threadStitchWidth;

    public Boolean isBlindStitch() {
        return this.blindStitch;
    }

    public void setBlindStitch(Boolean value) {
        this.blindStitch = value;
    }

    public Float getThreadLength() {
        return this.threadLength;
    }

    public void setThreadLength(Float value) {
        this.threadLength = value;
    }

    public List<Float> getThreadPositions() {
        if (this.threadPositions == null) {
            this.threadPositions = new ArrayList<Float>();
        }
        return this.threadPositions;
    }

    public Float getThreadStitchWidth() {
        return this.threadStitchWidth;
    }

    public void setThreadStitchWidth(Float value) {
        this.threadStitchWidth = value;
    }

    public ThreadSealingParams withBlindStitch(Boolean value) {
        this.setBlindStitch(value);
        return this;
    }

    public ThreadSealingParams withThreadLength(Float value) {
        this.setThreadLength(value);
        return this;
    }

    public ThreadSealingParams withThreadPositions(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getThreadPositions().add(value);
            }
        }
        return this;
    }

    public ThreadSealingParams withThreadPositions(Collection<Float> values) {
        if (values != null) {
            this.getThreadPositions().addAll(values);
        }
        return this;
    }

    public ThreadSealingParams withThreadStitchWidth(Float value) {
        this.setThreadStitchWidth(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Float> rightThreadPositions;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ThreadSealingParams that = (ThreadSealingParams)object;
        Boolean leftBlindStitch = this.isBlindStitch();
        Boolean rightBlindStitch = that.isBlindStitch();
        if (this.blindStitch != null) {
            if (that.blindStitch == null) return false;
            if (!leftBlindStitch.equals(rightBlindStitch)) {
                return false;
            }
        } else if (that.blindStitch != null) {
            return false;
        }
        Float leftThreadLength = this.getThreadLength();
        Float rightThreadLength = that.getThreadLength();
        if (this.threadLength != null) {
            if (that.threadLength == null) return false;
            if (!leftThreadLength.equals(rightThreadLength)) {
                return false;
            }
        } else if (that.threadLength != null) {
            return false;
        }
        List<Float> leftThreadPositions = this.threadPositions != null && !this.threadPositions.isEmpty() ? this.getThreadPositions() : null;
        List<Float> list = rightThreadPositions = that.threadPositions != null && !that.threadPositions.isEmpty() ? that.getThreadPositions() : null;
        if (this.threadPositions != null && !this.threadPositions.isEmpty()) {
            if (that.threadPositions == null || that.threadPositions.isEmpty()) return false;
            if (!leftThreadPositions.equals(rightThreadPositions)) {
                return false;
            }
        } else if (that.threadPositions != null && !that.threadPositions.isEmpty()) {
            return false;
        }
        Float leftThreadStitchWidth = this.getThreadStitchWidth();
        Float rightThreadStitchWidth = that.getThreadStitchWidth();
        if (this.threadStitchWidth != null) {
            if (that.threadStitchWidth == null) return false;
            if (leftThreadStitchWidth.equals(rightThreadStitchWidth)) return true;
            return false;
        }
        if (that.threadStitchWidth == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Float> theThreadPositions;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        Boolean theBlindStitch = this.isBlindStitch();
        if (this.blindStitch != null) {
            currentHashCode += theBlindStitch.hashCode();
        }
        currentHashCode *= 31;
        Float theThreadLength = this.getThreadLength();
        if (this.threadLength != null) {
            currentHashCode += theThreadLength.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list = theThreadPositions = this.threadPositions != null && !this.threadPositions.isEmpty() ? this.getThreadPositions() : null;
        if (this.threadPositions != null && !this.threadPositions.isEmpty()) {
            currentHashCode += theThreadPositions.hashCode();
        }
        currentHashCode *= 31;
        Float theThreadStitchWidth = this.getThreadStitchWidth();
        if (this.threadStitchWidth != null) {
            currentHashCode += theThreadStitchWidth.hashCode();
        }
        return currentHashCode;
    }
}

