/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.util;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;

public final class Partitions {
    private Partitions() {
        throw new RuntimeException("Class cannot be instantiated.");
    }

    public static Map<String, List<Object>> getPartKeyValues(ResourceSet resourceSet) throws IllegalAccessException {
        HashMap<String, List<Object>> partKeyValues = new HashMap<String, List<Object>>();
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResource()) {
                for (Part part : resource.getPart()) {
                    Field[] fields;
                    for (Field field : fields = FieldUtils.getAllFields(Part.class)) {
                        if (FieldUtils.readField((Field)field, (Object)part, (boolean)true) == null || field.getName().equals("otherAttributes")) continue;
                        String partKey = field.getAnnotation(XmlAttribute.class).name();
                        Object value = FieldUtils.readField((Field)field, (Object)part, (boolean)true);
                        if (!partKeyValues.containsKey(partKey)) {
                            partKeyValues.put(partKey, new ArrayList());
                        }
                        if (((List)partKeyValues.get(partKey)).contains(value)) continue;
                        ((List)partKeyValues.get(partKey)).add(value);
                    }
                }
            }
        }
        return partKeyValues;
    }

    public static Resource getResourceByPart(ResourceSet resourceSet, Part part) {
        List<Resource> resources = Partitions.getResourcesByPart(resourceSet, part);
        if (resources.size() > 1) {
            throw new IllegalArgumentException("Multiple resources have been found matching this part object.");
        }
        return resources.isEmpty() ? null : resources.get(0);
    }

    public static List<Resource> getResourcesByPart(ResourceSet resourceSet, Part part) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource resource : resourceSet.getResource()) {
            if (resource.getPart().isEmpty()) {
                return List.of(resource);
            }
            for (Part resourcePart : resource.getPart()) {
                if (!Partitions.getPartitionKeys(resourcePart).isEmpty()) continue;
                return List.of(resource);
            }
        }
        block2: for (Resource resource : resourceSet.getResource()) {
            for (Part resourcePart : resource.getPart()) {
                if (!Partitions.matches(resourcePart, part)) continue;
                result.add(resource);
                continue block2;
            }
        }
        return result;
    }

    static boolean matches(Part resourcePart, Part givenPart) {
        List<String> givenPartKeys = Partitions.getPartitionKeys(givenPart);
        try {
            for (String givenPartKey : givenPartKeys) {
                Object resValue = FieldUtils.readField((Object)resourcePart, (String)givenPartKey, (boolean)true);
                Object givenValue = FieldUtils.readField((Object)givenPart, (String)givenPartKey, (boolean)true);
                if (resValue != null && resValue.equals(givenValue)) continue;
                return false;
            }
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        return true;
    }

    static List<String> getPartitionKeys(Part part) {
        HashSet<String> partKeys = new HashSet<String>();
        if (part != null) {
            Field[] fields;
            for (Field field : fields = FieldUtils.getAllFields(Part.class)) {
                try {
                    if (FieldUtils.readField((Field)field, (Object)part, (boolean)true) == null || field.getName().equals("otherAttributes")) continue;
                    partKeys.add(field.getName());
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }
        return Collections.unmodifiableList(new ArrayList(partKeys));
    }
}

