/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator;

import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.cip4.lib.xjdf.validator.Ancestors;
import org.cip4.lib.xjdf.validator.ClassInspector;
import org.cip4.lib.xjdf.validator.ValidationResult;
import org.cip4.lib.xjdf.validator.ValidationResultBuilder;
import org.cip4.lib.xjdf.validator.element.Validator;
import org.jetbrains.annotations.NotNull;

public class ValidationDispatcher {
    private final Collection<Validator> validators;

    public ValidationDispatcher(Validator ... validators) {
        this.validators = Arrays.asList(validators);
    }

    public ValidationDispatcher(Collection<Validator> validators) {
        this.validators = validators;
    }

    public ValidationResult validate(Object element) {
        ValidationResultBuilder validationResult = new ValidationResultBuilder();
        this.validate(element, new Ancestors(), validationResult);
        return validationResult.build();
    }

    private void validate(Object element, Ancestors ancestors, ValidationResultBuilder validationResult) {
        for (Validator validator : this.validators) {
            if (!validator.canValidate(element)) continue;
            validator.validate(element, ancestors, validationResult);
        }
        Ancestors newAncestors = ancestors.push(element);
        for (Object child : this.getChildElements(element)) {
            this.validate(child, newAncestors, validationResult);
        }
    }

    public ChildElements getChildElements(Object element) {
        ChildElements childElements = new ChildElements(this);
        ClassInspector inspector = new ClassInspector(element.getClass());
        for (Method method : inspector.getGetters()) {
            Object propertyValue;
            if (inspector.isReference(method)) continue;
            try {
                propertyValue = method.invoke(element, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                continue;
            }
            if (propertyValue instanceof JAXBElement) {
                propertyValue = ((JAXBElement)propertyValue).getValue();
            }
            if (propertyValue instanceof Collection) {
                childElements.addAllAppropriate((Collection)propertyValue);
                continue;
            }
            if (propertyValue instanceof Map) {
                childElements.addAllAppropriate(((Map)propertyValue).values());
                continue;
            }
            childElements.addIfAppropriate(propertyValue);
        }
        return childElements;
    }

    class ChildElements
    implements Iterable<Object> {
        private final Collection<Object> elements = new LinkedList<Object>();

        ChildElements(ValidationDispatcher this$0) {
        }

        public void addIfAppropriate(Object o) {
            if (o != null && o.getClass().getPackage().getName().startsWith("org.cip4.lib.xjdf")) {
                this.elements.add(o);
            }
        }

        public void addAllAppropriate(Collection<Object> os) {
            for (Object o : os) {
                this.addIfAppropriate(o);
            }
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return this.elements.iterator();
        }
    }
}

