/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.type.IntegerList;
import org.cip4.lib.xjdf.validator.Ancestors;
import org.cip4.lib.xjdf.validator.ValidationResultBuilder;
import org.cip4.lib.xjdf.validator.element.Validator;

public class ResourceSetAmbiguityValidator
implements Validator<XJDF> {
    @Override
    public void validate(XJDF element, Ancestors ancestors, ValidationResultBuilder validationResult) {
        List<ResourceSet> resourceSets = element.getResourceSet();
        ArrayList<ResourceSetIdentity> identities = new ArrayList<ResourceSetIdentity>(resourceSets.size());
        for (ResourceSet resourceSet : resourceSets) {
            ResourceSetIdentity identity = new ResourceSetIdentity(this, resourceSet.getName(), resourceSet.getUsage(), resourceSet.getProcessUsage(), resourceSet.getCombinedProcessIndex());
            if (this.ambiguous(identities, identity)) {
                validationResult.append("ResourceSet elements with the same values of @Name, @Usage, @ProcessUsage and common or no entries in @CombinedProcessIndex SHALL NOT be specified.");
            }
            identities.add(identity);
        }
    }

    private boolean ambiguous(List<ResourceSetIdentity> identities, ResourceSetIdentity identity) {
        for (ResourceSetIdentity existingIdentity : identities) {
            if (!existingIdentity.ambiguous(identity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canValidate(Object o) {
        return o instanceof XJDF;
    }

    private class ResourceSetIdentity {
        final String name;
        final ResourceSet.Usage usage;
        final String processUsage;
        final IntegerList combinedProcessIndex;

        public ResourceSetIdentity(ResourceSetAmbiguityValidator resourceSetAmbiguityValidator, String name, ResourceSet.Usage usage, String processUsage, IntegerList combinedProcessIndex) {
            this.name = name;
            this.usage = usage;
            this.processUsage = processUsage;
            this.combinedProcessIndex = combinedProcessIndex;
        }

        public boolean ambiguous(ResourceSetIdentity o) {
            return Objects.equals(this.name, o.name) && this.usage == o.usage && Objects.equals(this.processUsage, o.processUsage) && this.combinedProcessIndexIsAmbiguous(o);
        }

        private boolean combinedProcessIndexIsAmbiguous(ResourceSetIdentity o) {
            if (null == this.combinedProcessIndex || null == o.combinedProcessIndex) {
                return true;
            }
            List combinedProcessIndex = this.combinedProcessIndex.getList();
            for (Integer processIndex : o.combinedProcessIndex.getList()) {
                if (!combinedProcessIndex.contains(processIndex)) continue;
                return true;
            }
            return false;
        }
    }
}

