/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.cip4.lib.xjdf.XJdfConstants;
import org.cip4.lib.xjdf.exception.XJdfValidationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XJdfValidator {
    public final void validate(byte[] xjdf) throws XJdfValidationException {
        this.validateSyntax(xjdf);
        this.validateSemantic(xjdf);
    }

    void validateSyntax(byte[] xjdf) throws XJdfValidationException {
        XJdfErrorHandler errorHandler = new XJdfErrorHandler();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(errorHandler);
            Document doc = documentBuilder.parse(new ByteArrayInputStream(xjdf));
            if (!errorHandler.getMessages().isEmpty()) {
                List<String> messages = errorHandler.getMessages();
                throw new XJdfValidationException("Validation of the document's syntax failed due to following error messages: " + System.lineSeparator() + StringUtils.join(messages, (String)System.lineSeparator()));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XJdfValidationException(e.getMessage(), e);
        }
    }

    final void validateSemantic(byte[] xjdf) throws XJdfValidationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource xsdSource = new StreamSource(new ByteArrayInputStream(XJdfConstants.XJDF_XSD_BYTES_CURRENT));
            Schema schema = schemaFactory.newSchema(xsdSource);
            XJdfErrorHandler errorHandler = new XJdfErrorHandler();
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(new StreamSource(new ByteArrayInputStream(xjdf)));
            List<String> messages = errorHandler.getMessages();
            if (messages.size() > 0) {
                throw new XJdfValidationException("Validation of the document's semantic failed due to following error messages: " + System.lineSeparator() + StringUtils.join(messages, (String)System.lineSeparator()));
            }
        }
        catch (IOException | SAXException e) {
            throw new XJdfValidationException(e.getMessage(), e);
        }
    }

    private static class XJdfErrorHandler
    implements ErrorHandler {
        private final List<String> messages = new ArrayList<String>();

        private XJdfErrorHandler() {
        }

        public List<String> getMessages() {
            return this.messages;
        }

        @Override
        public void warning(SAXParseException exception) {
            String msg = "WARNING in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void error(SAXParseException exception) {
            String msg = "ERROR in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            String msg = "FATAL in XJDF Doc ERROR at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }
    }
}

