/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xprinttalk.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.internal.NamespaceManager;
import org.xml.sax.InputSource;

public class PrintTalkConstants {
    public static final String NAMESPACE_PTK20 = PrintTalkConstants.loadNamespacePtk20();
    public static final String PTK_LIB_VERSION = PrintTalkConstants.loadLibraryVersion();
    public static final String PTK_LIB_BUILD_DATE = PrintTalkConstants.loadLibraryBuildDate();
    public static final String PTK_CURRENT_VERSION = "2.0";
    public static final byte[] PTK_XSD_BYTES = PrintTalkConstants.loadPtkByteArray();
    public static final String MEDIA_TYPE_PTK = "application/vnd.cip4-ptk+xml";
    public static final String MEDIA_TYPE_PTK_ZIP = "application/vnd.cip4-ptk+zip";
    private static final String RES_BUILD_PROPS = "/org/cip4/lib/xprinttalk/build.properties";
    private static final String RES_PTK20_XSD = "/PrintTalk20.xsd";

    private static byte[] loadPtkByteArray() {
        byte[] bytes = null;
        try (InputStream is = PrintTalkConstants.class.getResourceAsStream(RES_PTK20_XSD);){
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytes;
    }

    private static String loadNamespacePtk20() {
        String result;
        NamespaceManager nsManager = new NamespaceManager();
        nsManager.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext((NamespaceContext)nsManager);
        try {
            XPathExpression xPathExpression = xPath.compile("/xs:schema/@targetNamespace");
            InputStream is = XJdfConstants.class.getResourceAsStream(RES_PTK20_XSD);
            result = xPathExpression.evaluate(new InputSource(is));
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
        return result;
    }

    public static InputStream loadSchema() {
        return PrintTalkConstants.class.getResourceAsStream(RES_PTK20_XSD);
    }

    private static String loadLibraryVersion() {
        String result = null;
        Properties props = new Properties();
        try {
            props.load(XJdfConstants.class.getResourceAsStream(RES_BUILD_PROPS));
            result = props.getProperty("version", "UNKNOWN");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    private static String loadLibraryBuildDate() {
        String result = null;
        Properties props = new Properties();
        try {
            props.load(XJdfConstants.class.getResourceAsStream(RES_BUILD_PROPS));
            result = props.getProperty("build.date", "UNKNOWN");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            result = "";
        }
        return result;
    }
}

