/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xprinttalk.builder;

import org.cip4.lib.xjdf.XJdfNodeFactory;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.schema.GeneralID;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xprinttalk.PrintTalkNodeFactory;
import org.cip4.lib.xprinttalk.schema.Price;
import org.cip4.lib.xprinttalk.schema.Pricing;

public class PricingBuilder
extends AbstractNodeBuilder<Pricing> {
    private final PrintTalkNodeFactory ptkNodeFactory = new PrintTalkNodeFactory();
    private final XJdfNodeFactory xjdfNodeFactory = new XJdfNodeFactory();
    private int lineCounter = 0;

    public PricingBuilder() {
        super((Object)new PrintTalkNodeFactory().createPricing());
    }

    public Price appendPrice(XJDF xjdf, double price) {
        return this.appendPrice(xjdf, price, xjdf.getDescriptiveName());
    }

    public Price appendPrice(String descriptiveName, double price) {
        return this.appendPrice(null, price, descriptiveName);
    }

    public Price appendPrice(XJDF xjdf, double price, String descriptiveName) {
        String lineId = this.getNextLineId();
        Price obj = this.ptkNodeFactory.createPrice();
        obj.setDescriptiveName(descriptiveName);
        obj.setLineID(lineId);
        obj.setPrice(price);
        ((Pricing)this.getNode()).getPrice().add(obj);
        if (xjdf != null) {
            GeneralID generalID = this.xjdfNodeFactory.createGeneralID("Line_ID", lineId);
            xjdf.getGeneralID().add(generalID);
        }
        return obj;
    }

    public void appendTotalPriceWithTax(double tax) {
        Price obj = this.ptkNodeFactory.createPrice();
        double total = 0.0;
        for (Price price : ((Pricing)this.getNode()).getPrice()) {
            total += price.getPrice().doubleValue();
        }
        obj.setDescriptiveName(String.format("Tax %s %%", tax));
        obj.setPrice((double)Math.round(total * tax) / 100.0);
        obj.setLineID(this.getNextLineId());
        ((Pricing)this.getNode()).getPrice().add(obj);
        this.appendTotalPrice();
    }

    public Price appendTotalPrice() {
        Price obj = this.ptkNodeFactory.createPrice();
        double total = 0.0;
        for (Price price : ((Pricing)this.getNode()).getPrice()) {
            total += price.getPrice() * 100.0;
            obj.getLineIDRefs().add(price.getLineID());
        }
        obj.setDescriptiveName("Total");
        obj.setPrice((double)Math.round(total) / 100.0);
        obj.setLineID(this.getNextLineId());
        ((Pricing)this.getNode()).getPrice().add(obj);
        return obj;
    }

    private String getNextLineId() {
        ++this.lineCounter;
        String lineId = "Line_" + Integer.toString(this.lineCounter);
        return lineId;
    }
}

