/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xprinttalk.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.internal.AbstractXmlParser;
import org.cip4.lib.xjdf.xml.internal.XmlNavigator;
import org.cip4.lib.xprinttalk.xml.PrintTalkConstants;
import org.cip4.lib.xprinttalk.xml.PrintTalkParser;

public class PrintTalkNavigator
extends XmlNavigator {
    public static final String TIMESTAMP = "/PrintTalk/@Timestamp";
    public static final String BUSINESS_ID = "/PrintTalk/Request/PurchaseOrder/@BusinessID";
    public static final String CURRENCY = "/PrintTalk/Request/PurchaseOrder/@Currency";
    public static final String XJDF = "/PrintTalk/Request/PurchaseOrder";

    public PrintTalkNavigator(InputStream xPrintTalkStream) throws Exception {
        this(xPrintTalkStream, false);
    }

    public PrintTalkNavigator(InputStream xPrintTalkStream, boolean namespaceAware) throws Exception {
        super(xPrintTalkStream, namespaceAware);
        this.addNamespace("xjdf", XJdfConstants.NAMESPACE_JDF20);
        this.addNamespace("ptk", PrintTalkConstants.NAMESPACE_PTK20);
    }

    public PrintTalkNavigator(byte[] xPrintTalkBytes) throws Exception {
        super((InputStream)new ByteArrayInputStream(xPrintTalkBytes));
    }

    public PrintTalkNavigator(byte[] xPrintTalkBytes, boolean namespaceAware) throws Exception {
        this(new ByteArrayInputStream(xPrintTalkBytes), namespaceAware);
    }

    public PrintTalkNavigator(String ptkPath) throws Exception {
        this(new FileInputStream(ptkPath));
    }

    public PrintTalkNavigator(String ptkPath, boolean namespaceAware) throws Exception {
        this(new FileInputStream(ptkPath), namespaceAware);
    }

    public PrintTalkNavigator(File ptkFile) throws Exception {
        this(new FileInputStream(ptkFile));
    }

    public PrintTalkNavigator(File ptkFile, boolean namespaceAware) throws Exception {
        this(new FileInputStream(ptkFile), namespaceAware);
    }

    public byte[] getPtkBytes() throws Exception {
        return super.getXmlBytes();
    }

    public InputStream getPtkStream() throws Exception {
        return super.getXmlStream();
    }

    public String readXJdfAttribute(String xPathXJdf) throws XPathExpressionException {
        String xPath = XJDF + xPathXJdf;
        return this.readAttribute(xPath);
    }

    public Object extractNode(String xPath) throws XPathExpressionException, JAXBException {
        return super.extractNode(xPath, (AbstractXmlParser)new PrintTalkParser());
    }

    public void replaceNode(String xPath, Object replacement) throws XPathExpressionException, JAXBException, ParserConfigurationException {
        super.replaceNode(xPath, replacement, (AbstractXmlParser)new PrintTalkParser());
    }
}

