/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xprinttalk.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.internal.AbstractXmlParser;
import org.cip4.lib.xjdf.xml.internal.XmlNavigator;
import org.cip4.lib.xprinttalk.xml.PrintTalkConstants;
import org.cip4.lib.xprinttalk.xml.PrintTalkParser;
import org.xml.sax.SAXException;

public class PrintTalkNavigator
extends XmlNavigator {
    public static final String TIMESTAMP = "/PrintTalk/@Timestamp";
    public static final String BUSINESS_ID = "/PrintTalk/Request/PurchaseOrder/@BusinessID";
    public static final String CURRENCY = "/PrintTalk/Request/PurchaseOrder/@Currency";
    public static final String XJDF = "/PrintTalk/Request/PurchaseOrder";

    public PrintTalkNavigator(InputStream xPrintTalkStream) throws ParserConfigurationException, SAXException, IOException {
        this(xPrintTalkStream, false);
    }

    public PrintTalkNavigator(InputStream xPrintTalkStream, boolean namespaceAware) throws IOException, SAXException, ParserConfigurationException {
        super(xPrintTalkStream, namespaceAware);
        this.addNamespace("xjdf", XJdfConstants.NAMESPACE_JDF20);
        this.addNamespace("ptk", PrintTalkConstants.NAMESPACE_PTK20);
    }

    public PrintTalkNavigator(byte[] xPrintTalkBytes) throws ParserConfigurationException, SAXException, IOException {
        super((InputStream)new ByteArrayInputStream(xPrintTalkBytes));
    }

    public PrintTalkNavigator(byte[] xPrintTalkBytes, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        this(new ByteArrayInputStream(xPrintTalkBytes), namespaceAware);
    }

    public PrintTalkNavigator(String ptkPath) throws IOException, SAXException, ParserConfigurationException {
        this(new FileInputStream(ptkPath));
    }

    public PrintTalkNavigator(String ptkPath, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        this(new FileInputStream(ptkPath), namespaceAware);
    }

    public PrintTalkNavigator(File ptkFile) throws IOException, SAXException, ParserConfigurationException {
        this(new FileInputStream(ptkFile));
    }

    public PrintTalkNavigator(File ptkFile, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        this(new FileInputStream(ptkFile), namespaceAware);
    }

    public byte[] getPtkBytes() throws TransformerException, IOException {
        return super.getXmlBytes();
    }

    public InputStream getPtkStream() throws TransformerException, IOException {
        return super.getXmlStream();
    }

    public String readXJdfAttribute(String xPathXJdf) throws XPathExpressionException {
        String xPath = XJDF + xPathXJdf;
        return this.readAttribute(xPath);
    }

    public Object extractNode(String xPath) throws XPathExpressionException, JAXBException {
        return super.extractNode(xPath, (AbstractXmlParser)new PrintTalkParser());
    }

    public void replaceNode(String xPath, Object replacement) throws XPathExpressionException, JAXBException, ParserConfigurationException {
        super.replaceNode(xPath, replacement, (AbstractXmlParser)new PrintTalkParser());
    }
}

