/*
 * Copyright 2016 Miroslav Janíček
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.classdump.luna.exec;

import org.classdump.luna.exec.Continuation;

/**
 * A one-shot continuation, i.e., a continuation that may be resumed at most once.
 */
public interface OneShotContinuation extends Continuation {

	/**
	 * Returns {@code true} if this continuation is current, i.e., can be resumed.
	 *
	 * <p>In other words, returns {@code false} if an attempt to resume the continuation
	 * would throw a {@link InvalidContinuationException}.</p>
	 *
	 * @return  {@code true} if this continuation is valid, {@code false} otherwise
	 */
	boolean isCurrent();

}
