/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import org.classdump.luna.LuaMathOperators;

public abstract class Arithmetic {
    public static final Arithmetic INTEGER = new IntegerArithmetic();
    public static final Arithmetic FLOAT = new FloatArithmetic();

    private Arithmetic() {
    }

    public abstract Number add(Number var1, Number var2);

    public abstract Number sub(Number var1, Number var2);

    public abstract Number mul(Number var1, Number var2);

    public abstract Double div(Number var1, Number var2);

    public abstract Number mod(Number var1, Number var2);

    public abstract Number idiv(Number var1, Number var2);

    public abstract Double pow(Number var1, Number var2);

    public abstract Number unm(Number var1);

    public static Arithmetic of(Number a, Number b) {
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof Double || a instanceof Float || b instanceof Double || b instanceof Float) {
            return FLOAT;
        }
        return INTEGER;
    }

    public static Arithmetic of(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Double || n instanceof Float) {
            return FLOAT;
        }
        return INTEGER;
    }

    private static final class FloatArithmetic
    extends Arithmetic {
        private FloatArithmetic() {
        }

        @Override
        public Double add(Number a, Number b) {
            return LuaMathOperators.add(a.doubleValue(), b.doubleValue());
        }

        @Override
        public Double sub(Number a, Number b) {
            return LuaMathOperators.sub(a.doubleValue(), b.doubleValue());
        }

        @Override
        public Double mul(Number a, Number b) {
            return LuaMathOperators.mul(a.doubleValue(), b.doubleValue());
        }

        @Override
        public Double div(Number a, Number b) {
            return LuaMathOperators.div(a.doubleValue(), b.doubleValue());
        }

        @Override
        public Double mod(Number a, Number b) {
            return LuaMathOperators.mod(a.doubleValue(), b.doubleValue());
        }

        @Override
        public Double idiv(Number a, Number b) {
            return LuaMathOperators.idiv(a.doubleValue(), b.doubleValue());
        }

        @Override
        public Double pow(Number a, Number b) {
            return LuaMathOperators.pow(a.doubleValue(), b.doubleValue());
        }

        @Override
        public Double unm(Number n) {
            return LuaMathOperators.unm(n.doubleValue());
        }
    }

    private static final class IntegerArithmetic
    extends Arithmetic {
        private IntegerArithmetic() {
        }

        @Override
        public Long add(Number a, Number b) {
            return LuaMathOperators.add(a.longValue(), b.longValue());
        }

        @Override
        public Long sub(Number a, Number b) {
            return LuaMathOperators.sub(a.longValue(), b.longValue());
        }

        @Override
        public Long mul(Number a, Number b) {
            return LuaMathOperators.mul(a.longValue(), b.longValue());
        }

        @Override
        public Double div(Number a, Number b) {
            return LuaMathOperators.div(a.longValue(), b.longValue());
        }

        @Override
        public Long mod(Number a, Number b) {
            return LuaMathOperators.mod(a.longValue(), b.longValue());
        }

        @Override
        public Long idiv(Number a, Number b) {
            return LuaMathOperators.idiv(a.longValue(), b.longValue());
        }

        @Override
        public Double pow(Number a, Number b) {
            return LuaMathOperators.pow(a.longValue(), b.longValue());
        }

        @Override
        public Long unm(Number n) {
            return LuaMathOperators.unm(n.longValue());
        }
    }
}

