/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import org.classdump.luna.ArrayByteString;
import org.classdump.luna.ByteStringInputStream;
import org.classdump.luna.StringByteString;
import org.classdump.luna.util.ByteIterator;

public abstract class ByteString
implements Comparable<ByteString> {
    ByteString() {
    }

    public static ByteString of(String s, Charset charset) {
        return new StringByteString(s, charset);
    }

    public static ByteString of(String s) {
        return ByteString.of(s, Charset.defaultCharset());
    }

    public static ByteString fromRaw(String s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(s.charAt(i) & 0xFF);
        }
        return ByteString.wrap(bytes);
    }

    public static ByteString constOf(String s) {
        return ByteString.of(s);
    }

    static ByteString wrap(byte[] bytes) {
        return new ArrayByteString(bytes);
    }

    public static ByteString copyOf(byte[] bytes) {
        return ByteString.copyOf(bytes, 0, bytes.length);
    }

    public static ByteString copyOf(byte[] bytes, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", length=" + length);
        }
        return ByteString.wrap(Arrays.copyOfRange(bytes, offset, length));
    }

    public static ByteString empty() {
        return ArrayByteString.EMPTY_INSTANCE;
    }

    public final boolean equals(Object o) {
        return this == o || o instanceof ByteString && this.equalsByteString((ByteString)o);
    }

    public abstract int hashCode();

    abstract int maybeHashCode();

    abstract boolean equalsByteString(ByteString var1);

    public abstract byte[] getBytes();

    public abstract byte byteAt(int var1);

    public abstract ByteIterator byteIterator();

    public InputStream asInputStream() {
        return new ByteStringInputStream(this.byteIterator());
    }

    public abstract int length();

    abstract int maybeLength();

    public abstract boolean isEmpty();

    public abstract ByteString substring(int var1, int var2);

    public abstract void putTo(ByteBuffer var1);

    public abstract void writeTo(OutputStream var1) throws IOException;

    public abstract String toString();

    public String decode(Charset charset) {
        if (this.isEmpty()) {
            return "";
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.length());
        this.putTo(byteBuffer);
        byteBuffer.flip();
        return charset.decode(byteBuffer).toString();
    }

    public String decode() {
        return this.decode(Charset.defaultCharset());
    }

    public abstract String toRawString();

    @Override
    public int compareTo(ByteString that) {
        Objects.requireNonNull(that);
        ByteIterator thisIterator = this.byteIterator();
        ByteIterator thatIterator = that.byteIterator();
        while (thisIterator.hasNext() && thatIterator.hasNext()) {
            int thatByte;
            int thisByte = thisIterator.nextByte() & 0xFF;
            int diff = thisByte - (thatByte = thatIterator.nextByte() & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return thisIterator.hasNext() ? 1 : (thatIterator.hasNext() ? -1 : 0);
    }

    public ByteString concat(ByteString other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        byte[] thisBytes = this.getBytes();
        byte[] otherBytes = other.getBytes();
        byte[] result = new byte[thisBytes.length + otherBytes.length];
        System.arraycopy(thisBytes, 0, result, 0, thisBytes.length);
        System.arraycopy(otherBytes, 0, result, thisBytes.length, otherBytes.length);
        return ByteString.wrap(result);
    }

    public ByteString concat(String other) {
        return this.concat(ByteString.of(other));
    }

    public abstract boolean startsWith(byte var1);

    public boolean contains(byte b) {
        ByteIterator it = this.byteIterator();
        while (it.hasNext()) {
            if (b != it.nextByte()) continue;
            return true;
        }
        return false;
    }

    public ByteString replace(ByteString target, ByteString replacement) {
        return ByteString.fromRaw(this.toRawString().replace(target.toRawString(), replacement.toRawString()));
    }
}

