/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import org.classdump.luna.Conversions;

public class LuaRuntimeException
extends RuntimeException {
    private final Object errorObject;

    private LuaRuntimeException(Throwable cause, Object errorObject) {
        super(cause);
        this.errorObject = errorObject;
    }

    public LuaRuntimeException(Object errorObject) {
        this(null, errorObject);
    }

    public LuaRuntimeException(Throwable cause) {
        this(cause, null);
    }

    @Override
    public String getMessage() {
        return this.getErrorLocation() + Conversions.toHumanReadableString(this.getErrorObject()).toString();
    }

    public Object getErrorObject() {
        Throwable cause = this.getCause();
        if (cause != null) {
            return Conversions.toErrorObject(cause);
        }
        return this.errorObject;
    }

    public String getErrorLocation() {
        for (StackTraceElement stackTraceElement : this.getStackTrace()) {
            if (!stackTraceElement.getClassName().startsWith("luna_dynamic")) continue;
            return stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ": ";
        }
        return "";
    }
}

