/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.compiler.analysis.types.GradualTypeLike;
import org.classdump.luna.compiler.analysis.types.LuaTypes;
import org.classdump.luna.compiler.analysis.types.PartialOrderComparisonResult;
import org.classdump.luna.compiler.analysis.types.Type;
import org.classdump.luna.util.Check;

public class TypeSeq
implements GradualTypeLike<TypeSeq> {
    protected final List<Type> fixed;
    protected final Type tailType;

    TypeSeq(List<Type> fixed, Type tailType) {
        this.fixed = Objects.requireNonNull(fixed);
        this.tailType = Objects.requireNonNull(tailType);
    }

    public static TypeSeq empty() {
        return TypeSeq.of(new Type[0]);
    }

    public static TypeSeq vararg() {
        return TypeSeq.of(new Type[0]).withVararg();
    }

    public static TypeSeq of(Type ... fixed) {
        return TypeSeq.of(Arrays.asList(fixed), false);
    }

    public static TypeSeq of(List<Type> fixed, boolean vararg) {
        return new TypeSeq(fixed, vararg ? LuaTypes.ANY : LuaTypes.NIL);
    }

    public TypeSeq withVararg() {
        return new TypeSeq(this.fixed, LuaTypes.ANY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSeq that = (TypeSeq)o;
        return this.tailType.equals(that.tailType) && this.fixed.equals(that.fixed);
    }

    public int hashCode() {
        int result = this.fixed.hashCode();
        result = 31 * result + this.tailType.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append('(');
        String tail = this.tailType.equals(LuaTypes.NIL) ? "" : this.tailType.toString() + "*";
        Iterator<Type> it = this.fixed.iterator();
        while (it.hasNext()) {
            Type t = it.next();
            bld.append(t.toString());
            if (!it.hasNext() && tail.isEmpty()) continue;
            bld.append(',');
        }
        if (!tail.isEmpty()) {
            bld.append(tail);
        }
        bld.append(')');
        return bld.toString();
    }

    public List<Type> fixed() {
        return this.fixed;
    }

    public Type tailType() {
        return this.tailType;
    }

    public Type get(int idx) {
        Check.nonNegative(idx);
        return idx < this.fixed().size() ? this.fixed().get(idx) : this.tailType;
    }

    public TypeSeq prefixedBy(Type[] types) {
        Objects.requireNonNull(types);
        ArrayList<Type> ts = new ArrayList<Type>(types.length + this.fixed.size());
        ts.addAll(Arrays.asList(types));
        ts.addAll(this.fixed);
        return new TypeSeq(Collections.unmodifiableList(ts), this.tailType);
    }

    public boolean isSubsumedBy(TypeSeq that) {
        Objects.requireNonNull(that);
        for (int i = 0; i < Math.max(this.fixed().size(), that.fixed().size()); ++i) {
            if (this.get(i).isSubtypeOf(that.get(i))) continue;
            return false;
        }
        return this.tailType.isSubtypeOf(that.tailType);
    }

    public TypeSeq join(TypeSeq that) {
        Objects.requireNonNull(that);
        ArrayList<Type> fix = new ArrayList<Type>();
        for (int i = 0; i < Math.max(this.fixed().size(), that.fixed().size()); ++i) {
            Type j = this.get(i).join(that.get(i));
            if (j == null) {
                return null;
            }
            fix.add(j);
        }
        Type tt = this.tailType.join(that.tailType);
        if (tt != null) {
            return new TypeSeq(Collections.unmodifiableList(fix), tt);
        }
        return null;
    }

    public TypeSeq meet(TypeSeq that) {
        Objects.requireNonNull(that);
        ArrayList<Type> fix = new ArrayList<Type>();
        for (int i = 0; i < Math.max(this.fixed().size(), that.fixed().size()); ++i) {
            Type m = this.get(i).meet(that.get(i));
            if (m == null) {
                return null;
            }
            fix.add(m);
        }
        Type tt = this.tailType.meet(that.tailType);
        if (tt != null) {
            return new TypeSeq(Collections.unmodifiableList(fix), tt);
        }
        return null;
    }

    public PartialOrderComparisonResult comparePointwiseTo(TypeSeq that) {
        Objects.requireNonNull(that);
        int len = Math.max(this.fixed().size(), that.fixed().size());
        PartialOrderComparisonResult result = null;
        for (int i = 0; i < len; ++i) {
            PartialOrderComparisonResult r = this.get(i).compareTo(that.get(i));
            if (!r.isDefined()) {
                return PartialOrderComparisonResult.NOT_COMPARABLE;
            }
            if (result != null || r == PartialOrderComparisonResult.EQUAL) continue;
            result = r;
        }
        PartialOrderComparisonResult tr = this.tailType.compareTo(that.tailType);
        if (result != null && tr.isDefined()) {
            return result;
        }
        return tr;
    }

    @Override
    public boolean isConsistentWith(TypeSeq that) {
        Objects.requireNonNull(that);
        for (int i = 0; i < Math.max(this.fixed().size(), that.fixed().size()); ++i) {
            if (this.get(i).isConsistentWith(that.get(i))) continue;
            return false;
        }
        return this.tailType.isConsistentWith(that.tailType);
    }

    public TypeSeq restrict(TypeSeq that) {
        Objects.requireNonNull(that);
        ArrayList<Type> ts = new ArrayList<Type>();
        for (int i = 0; i < Math.max(this.fixed().size(), that.fixed().size()); ++i) {
            ts.add(this.get(i).restrict(that.get(i)));
        }
        return new TypeSeq(Collections.unmodifiableList(ts), this.tailType.restrict(that.tailType));
    }

    @Override
    public boolean isConsistentSubtypeOf(TypeSeq that) {
        Objects.requireNonNull(that);
        for (int i = 0; i < Math.max(this.fixed().size(), that.fixed().size()); ++i) {
            if (this.get(i).isConsistentSubtypeOf(that.get(i))) continue;
            return false;
        }
        return this.tailType.isConsistentSubtypeOf(that.tailType);
    }
}

