/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import org.classdump.luna.compiler.gen.asm.helpers.ReflectionUtils;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;

public class DispatchMethods {
    public static final String OP_ADD = "add";
    public static final String OP_SUB = "sub";
    public static final String OP_MUL = "mul";
    public static final String OP_DIV = "div";
    public static final String OP_MOD = "mod";
    public static final String OP_POW = "pow";
    public static final String OP_UNM = "unm";
    public static final String OP_IDIV = "idiv";
    public static final String OP_BAND = "band";
    public static final String OP_BOR = "bor";
    public static final String OP_BXOR = "bxor";
    public static final String OP_BNOT = "bnot";
    public static final String OP_SHL = "shl";
    public static final String OP_SHR = "shr";
    public static final String OP_CONCAT = "concat";
    public static final String OP_LEN = "len";
    public static final String OP_EQ = "eq";
    public static final String OP_NEQ = "neq";
    public static final String OP_LT = "lt";
    public static final String OP_LE = "le";
    public static final String OP_INDEX = "index";
    public static final String OP_SETINDEX = "setindex";
    public static final String OP_CALL = "call";
    public static final int MAX_CALL_KIND;

    private DispatchMethods() {
    }

    public static AbstractInsnNode dynamic(String methodName, int numArgs) {
        ArrayList<Type> args = new ArrayList<Type>();
        args.add(Type.getType(ExecutionContext.class));
        for (int i = 0; i < numArgs; ++i) {
            args.add(Type.getType(Object.class));
        }
        return new MethodInsnNode(184, Type.getInternalName(Dispatch.class), methodName, Type.getMethodDescriptor(Type.VOID_TYPE, args.toArray(new Type[0])), false);
    }

    public static AbstractInsnNode numeric(String methodName, int numArgs) {
        Object[] args = new Type[numArgs];
        Arrays.fill(args, Type.getType(Number.class));
        return new MethodInsnNode(184, Type.getInternalName(Dispatch.class), methodName, Type.getMethodDescriptor(Type.getType(Number.class), (Type[])args), false);
    }

    public static AbstractInsnNode index() {
        return DispatchMethods.dynamic(OP_INDEX, 2);
    }

    public static AbstractInsnNode setindex() {
        return DispatchMethods.dynamic(OP_SETINDEX, 3);
    }

    public static int adjustKind_call(int kind) {
        return kind > 0 ? (DispatchMethods.call_method(kind).exists() ? kind : 0) : 0;
    }

    private static ReflectionUtils.Method call_method(int kind) {
        return ReflectionUtils.staticArgListMethodFromKind(Dispatch.class, OP_CALL, new Class[]{ExecutionContext.class, Object.class}, kind);
    }

    public static AbstractInsnNode call(int kind) {
        return DispatchMethods.call_method(kind).toMethodInsnNode();
    }

    public static AbstractInsnNode continueLoop() {
        return new MethodInsnNode(184, Type.getInternalName(Dispatch.class), "signed_le", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.getType(Number.class), Type.getType(Number.class), Type.getType(Number.class)), false);
    }

    static {
        int k = 1;
        while (DispatchMethods.call_method(k).exists()) {
            ++k;
        }
        MAX_CALL_KIND = k - 1;
    }
}

