/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;

public class ReflectionUtils {
    private static Method argListMethodFromKind(boolean isStatic, Class<?> owner, String name, Class<?>[] prefix, int kind) {
        ArrayList<Class> args = new ArrayList<Class>();
        if (prefix != null) {
            Collections.addAll(args, prefix);
        }
        if (kind > 0) {
            for (int i = 0; i < kind - 1; ++i) {
                args.add(Object.class);
            }
        } else {
            args.add(Object[].class);
        }
        return new Method(owner, name, isStatic, Void.TYPE, args.toArray(new Class[0]));
    }

    public static Method staticArgListMethodFromKind(Class<?> owner, String name, Class<?>[] prefix, int kind) {
        return ReflectionUtils.argListMethodFromKind(true, owner, name, prefix, kind);
    }

    public static Method virtualArgListMethodFromKind(Class<?> owner, String name, Class<?>[] prefix, int kind) {
        return ReflectionUtils.argListMethodFromKind(false, owner, name, prefix, kind);
    }

    public static class Method {
        public final Class<?> owner;
        public final String name;
        public final boolean isStatic;
        public final Class<?> returnType;
        public final Class<?>[] args;

        public Method(Class<?> owner, String name, boolean isStatic, Class<?> returnType, Class<?>[] args) {
            this.owner = Objects.requireNonNull(owner);
            this.name = name;
            this.isStatic = isStatic;
            this.returnType = Objects.requireNonNull(returnType);
            this.args = args != null ? args : new Class[]{};
        }

        public boolean exists() {
            try {
                this.owner.getMethod(this.name, this.args);
                return true;
            }
            catch (NoSuchMethodException ex) {
                return false;
            }
        }

        public Type getMethodType() {
            Type[] ts = new Type[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                ts[i] = Type.getType(this.args[i]);
            }
            return Type.getMethodType(Type.getType(this.returnType), ts);
        }

        public MethodInsnNode toMethodInsnNode() {
            return new MethodInsnNode(this.isStatic ? 184 : (this.owner.isInterface() ? 185 : 182), Type.getInternalName(this.owner), this.name, this.getMethodType().getDescriptor(), this.owner.isInterface());
        }
    }
}

