/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BlockTermNode;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.Branch;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.JmpNode;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.Line;
import org.classdump.luna.compiler.ir.ToNext;
import org.classdump.luna.parser.util.Util;

public class CodeBuilder {
    private final Map<Label, Integer> uses = new HashMap<Label, Integer>();
    private final Set<Label> pending = new HashSet<Label>();
    private final Set<Label> visited = new HashSet<Label>();
    private final List<BasicBlock> basicBlocks = new ArrayList<BasicBlock>();
    private int labelIdx = 0;
    private Block currentBlock = null;
    private int currentLine = 0;

    public CodeBuilder() {
        this.add(this.newLabel());
    }

    public Label newLabel() {
        return new Label(this.labelIdx++);
    }

    public boolean isInBlock() {
        return this.currentBlock != null;
    }

    private void closeCurrentBlock(BlockTermNode end) {
        if (this.currentBlock != null) {
            this.basicBlocks.add(this.currentBlock.toBasicBlock(end));
        }
        this.currentBlock = null;
    }

    private void appendToCurrentBlock(BodyNode node) {
        if (this.currentBlock != null) {
            this.currentBlock.add(node);
        }
    }

    public void add(Label label) {
        Objects.requireNonNull(label);
        this.pending.remove(label);
        if (!this.visited.add(label)) {
            throw new IllegalStateException("Label already used: " + label);
        }
        if (this.currentBlock != null) {
            this.closeCurrentBlock(new ToNext(label));
        }
        assert (this.currentBlock == null);
        this.currentBlock = new Block(label);
        if (this.currentLine > 0) {
            this.addLine(this.currentLine);
        }
    }

    public void add(BodyNode node) {
        Objects.requireNonNull(node);
        if (node instanceof JmpNode) {
            this.useLabel(((JmpNode)((Object)node)).jmpDest());
        }
        this.appendToCurrentBlock(node);
    }

    public void add(BlockTermNode node) {
        Objects.requireNonNull(node);
        if (node instanceof JmpNode) {
            this.useLabel(((JmpNode)((Object)node)).jmpDest());
        }
        this.closeCurrentBlock(node);
    }

    public void addBranch(Branch.Condition cond, Label dest) {
        Label next = this.newLabel();
        this.add(new Branch(cond, dest, next));
        this.add(next);
    }

    private void addLine(int line) {
        this.add(new Line(line));
    }

    public void atLine(int line) {
        if (line > 0 && line != this.currentLine) {
            this.currentLine = line;
            this.addLine(line);
        }
    }

    private int uses(Label l) {
        Objects.requireNonNull(l);
        Integer n = this.uses.get(l);
        return n != null ? n : 0;
    }

    private void useLabel(Label l) {
        Objects.requireNonNull(l);
        this.uses.put(l, this.uses(l) + 1);
        if (!this.visited.contains(l)) {
            this.pending.add(l);
        }
    }

    public Code build() {
        if (!this.pending.isEmpty()) {
            throw new IllegalStateException("Label(s) not defined: " + Util.iterableToString(this.pending, ", "));
        }
        if (this.currentBlock != null) {
            throw new IllegalStateException("Control reaches end of function");
        }
        return Code.of(this.basicBlocks);
    }

    private static class Block {
        private final Label label;
        private final List<BodyNode> body;

        private Block(Label label) {
            this.label = label;
            this.body = new ArrayList<BodyNode>();
        }

        public void add(BodyNode n) {
            this.body.add(n);
        }

        public BasicBlock toBasicBlock(BlockTermNode end) {
            return new BasicBlock(this.label, Collections.unmodifiableList(this.body), end);
        }
    }
}

