/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.tf;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BinOp;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.Branch;
import org.classdump.luna.compiler.ir.CPUWithdraw;
import org.classdump.luna.compiler.ir.Call;
import org.classdump.luna.compiler.ir.Closure;
import org.classdump.luna.compiler.ir.IRNode;
import org.classdump.luna.compiler.ir.Jmp;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.Ret;
import org.classdump.luna.compiler.ir.TCall;
import org.classdump.luna.compiler.ir.TabGet;
import org.classdump.luna.compiler.ir.TabNew;
import org.classdump.luna.compiler.ir.TabRawAppendMulti;
import org.classdump.luna.compiler.ir.TabRawSet;
import org.classdump.luna.compiler.ir.TabRawSetInt;
import org.classdump.luna.compiler.ir.TabSet;
import org.classdump.luna.compiler.ir.ToNumber;
import org.classdump.luna.compiler.ir.UnOp;
import org.classdump.luna.compiler.tf.CodeTransformerVisitor;
import org.classdump.luna.compiler.util.DefaultNodeActionVisitor;
import org.classdump.luna.util.Check;

class CPUAccountingVisitor
extends CodeTransformerVisitor {
    private final Account acc;
    public static final Account INITIALISE = new Account(){

        @Override
        public void cpuNode(CPUWithdraw node) {
        }

        @Override
        public void noCost() {
        }

        @Override
        public void staticCost(int c) {
            this.add(c);
        }

        @Override
        public void dynamicCost() {
        }
    };
    public static final Account COLLECT = new Account(){

        @Override
        public void cpuNode(CPUWithdraw node) {
            this.add(node.cost());
        }

        @Override
        public void noCost() {
        }

        @Override
        public void staticCost(int c) {
        }

        @Override
        public void dynamicCost() {
        }
    };

    public CPUAccountingVisitor(Account acc) {
        super(new Visitor(acc));
        this.acc = Objects.requireNonNull(acc);
    }

    private static void removeCPUNodes(Iterable<BodyNode> nodes) {
        Iterator<BodyNode> it = nodes.iterator();
        while (it.hasNext()) {
            BodyNode n = it.next();
            if (!(n instanceof CPUWithdraw)) continue;
            it.remove();
        }
    }

    @Override
    public void postVisit(BasicBlock block) {
        try {
            int cost = this.acc.get();
            CPUAccountingVisitor.removeCPUNodes(this.currentBody());
            if (cost > 0) {
                this.currentBody().add(0, new CPUWithdraw(cost));
            }
        }
        finally {
            this.acc.reset();
        }
    }

    private static class Visitor
    extends DefaultNodeActionVisitor {
        private final Account account;
        private final Set<Label> visitedLabels;

        public Visitor(Account account) {
            this.account = Objects.requireNonNull(account);
            this.visitedLabels = new HashSet<Label>();
        }

        @Override
        protected void action(IRNode node) {
            this.account.noCost();
        }

        @Override
        public void visit(CPUWithdraw node) {
            this.account.cpuNode(node);
        }

        @Override
        public void visit(Label label) {
            this.visitedLabels.add(label);
        }

        @Override
        public void visit(BinOp node) {
            this.account.staticCost();
        }

        @Override
        public void visit(UnOp node) {
            this.account.staticCost();
        }

        @Override
        public void visit(TabNew node) {
            this.account.staticCost();
        }

        @Override
        public void visit(TabGet node) {
            this.account.staticCost();
        }

        @Override
        public void visit(TabSet node) {
            this.account.staticCost();
        }

        @Override
        public void visit(TabRawSet node) {
            this.account.staticCost();
        }

        @Override
        public void visit(TabRawSetInt node) {
            this.account.staticCost();
        }

        @Override
        public void visit(TabRawAppendMulti node) {
            this.account.dynamicCost();
        }

        @Override
        public void visit(Ret node) {
            this.account.staticCost();
        }

        @Override
        public void visit(TCall node) {
            this.account.staticCost();
        }

        @Override
        public void visit(Call node) {
            this.account.staticCost();
        }

        @Override
        public void visit(Closure node) {
            this.account.staticCost();
        }

        @Override
        public void visit(ToNumber node) {
            this.account.staticCost();
        }

        @Override
        public void visit(Branch node) {
            this.account.staticCost();
        }

        @Override
        public void visit(Jmp node) {
            if (this.visitedLabels.contains(node.jmpDest())) {
                this.account.staticCost();
            }
        }
    }

    public static abstract class Account {
        private int cost;

        public int get() {
            return this.cost;
        }

        public void reset() {
            this.cost = 0;
        }

        protected void add(int c) {
            this.cost += Check.nonNegative(c);
        }

        public abstract void cpuNode(CPUWithdraw var1);

        public abstract void noCost();

        public abstract void staticCost(int var1);

        public void staticCost() {
            this.staticCost(1);
        }

        public abstract void dynamicCost();
    }
}

