/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.IRNode;
import org.classdump.luna.compiler.ir.Label;

public abstract class CodeUtils {
    private CodeUtils() {
    }

    public static Iterator<IRNode> nodeIterator(Code code) {
        return new NodeIterator(code.blockIterator());
    }

    public static Iterable<Label> labelsBreadthFirst(Code code) {
        Objects.requireNonNull(code);
        ArrayList<Label> result = new ArrayList<Label>();
        HashSet<Label> visited = new HashSet<Label>();
        ArrayDeque<Label> open = new ArrayDeque<Label>();
        open.add(code.entryLabel());
        while (!open.isEmpty()) {
            Label l = (Label)open.poll();
            BasicBlock bb = code.block(l);
            if (!visited.add(l)) continue;
            result.add(l);
            for (Label nxt : bb.end().nextLabels()) {
                open.add(nxt);
            }
        }
        result.trimToSize();
        return result;
    }

    public static Map<Label, Set<Label>> inLabels(Code code) {
        Objects.requireNonNull(code);
        HashMap result = new HashMap();
        for (Label l : code.labels()) {
            result.put(l, new HashSet());
        }
        HashSet<Label> visited = new HashSet<Label>();
        ArrayDeque<Label> open = new ArrayDeque<Label>();
        open.add(code.entryLabel());
        while (!open.isEmpty()) {
            Label l = (Label)open.pop();
            boolean cont = visited.add(l);
            for (Label m : code.block(l).end().nextLabels()) {
                ((Set)result.get(m)).add(l);
                if (!cont) continue;
                open.add(m);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private static class BlockNodeIterator
    implements Iterator<IRNode> {
        private final BasicBlock block;
        private int idx;

        public BlockNodeIterator(BasicBlock block) {
            this.block = Objects.requireNonNull(block);
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx <= this.block.body().size();
        }

        @Override
        public IRNode next() {
            int i;
            if ((i = this.idx++) == this.block.body().size()) {
                return this.block.end();
            }
            if (i < this.block.body().size()) {
                return this.block.body().get(i);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class NodeIterator
    implements Iterator<IRNode> {
        private final Iterator<BasicBlock> blockIterator;
        private Iterator<IRNode> blockNodeIterator;

        public NodeIterator(Iterator<BasicBlock> blockIterator) {
            this.blockIterator = Objects.requireNonNull(blockIterator);
            this.blockNodeIterator = null;
        }

        @Override
        public boolean hasNext() {
            if (this.blockNodeIterator != null && this.blockNodeIterator.hasNext()) {
                return true;
            }
            if (this.blockIterator.hasNext()) {
                this.blockNodeIterator = new BlockNodeIterator(this.blockIterator.next());
                return this.hasNext();
            }
            return false;
        }

        @Override
        public IRNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.blockNodeIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

