/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.Metatables;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.TableFactory;
import org.classdump.luna.env.RuntimeEnvironment;
import org.classdump.luna.impl.UnimplementedFunction;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.BadArgumentException;
import org.classdump.luna.lib.BasicLib;
import org.classdump.luna.lib.IoFile;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.lib.io.InputStreamIoFile;
import org.classdump.luna.lib.io.OutputStreamIoFile;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.UnresolvedControlThrowable;

public final class IoLib {
    static final LuaFunction TYPE = new Type();
    static final LuaFunction FILE_CLOSE = new IoFile.Close();
    static final LuaFunction FILE_FLUSH = new IoFile.Flush();
    static final LuaFunction FILE_LINES = new IoFile.Lines();
    static final LuaFunction FILE_READ = new IoFile.Read();
    static final LuaFunction FILE_SEEK = new IoFile.Seek();
    static final LuaFunction FILE_SETVBUF = new IoFile.SetVBuf();
    static final LuaFunction FILE_TOSTRING = new IoFile.ToString();
    static final LuaFunction FILE_WRITE = new IoFile.Write();
    private final LuaFunction _close;
    private final LuaFunction _flush;
    private final LuaFunction _input;
    private final LuaFunction _lines;
    private final LuaFunction _open;
    private final LuaFunction _output;
    private final LuaFunction _popen;
    private final LuaFunction _read;
    private final LuaFunction _tmpfile;
    private final LuaFunction _write;
    private final Table fileMetatable;
    private final FileSystem fileSystem;
    private final IoFile stdIn;
    private final IoFile stdOut;
    private final IoFile stdErr;
    private IoFile defaultInput;
    private IoFile defaultOutput;

    public static LuaFunction type() {
        return TYPE;
    }

    public static LuaFunction file_close() {
        return FILE_CLOSE;
    }

    public static LuaFunction file_flush() {
        return FILE_FLUSH;
    }

    public static LuaFunction file_lines() {
        return FILE_LINES;
    }

    public static LuaFunction file_read() {
        return FILE_READ;
    }

    public static LuaFunction file_seek() {
        return FILE_SEEK;
    }

    public static LuaFunction file_setvbuf() {
        return FILE_SETVBUF;
    }

    public static LuaFunction file_tostring() {
        return FILE_TOSTRING;
    }

    public static LuaFunction file_write() {
        return FILE_WRITE;
    }

    private IoLib(TableFactory tableFactory, FileSystem fileSystem, InputStream in, OutputStream out, OutputStream err) {
        Table mt;
        Objects.requireNonNull(tableFactory);
        this.fileMetatable = mt = tableFactory.newTable();
        mt.rawset(Metatables.MT_INDEX, (Object)mt);
        mt.rawset(BasicLib.MT_NAME, (Object)IoFile.typeName());
        mt.rawset(BasicLib.MT_TOSTRING, (Object)IoLib.file_tostring());
        mt.rawset("close", (Object)IoLib.file_close());
        mt.rawset("flush", (Object)IoLib.file_flush());
        mt.rawset("lines", (Object)IoLib.file_lines());
        mt.rawset("read", (Object)IoLib.file_read());
        mt.rawset("seek", (Object)IoLib.file_seek());
        mt.rawset("setvbuf", (Object)IoLib.file_setvbuf());
        mt.rawset("write", (Object)IoLib.file_write());
        this.fileSystem = fileSystem;
        this.stdIn = in != null ? new InputStreamIoFile(in, mt, null) : null;
        this.stdOut = out != null ? new OutputStreamIoFile(out, mt, null) : null;
        this.stdErr = err != null ? new OutputStreamIoFile(err, mt, null) : null;
        this.defaultInput = this.stdIn;
        this.defaultOutput = this.stdOut;
        this._close = new Close(this);
        this._flush = new Flush(this);
        this._input = new Input(this);
        this._lines = new Lines(this);
        this._open = new Open(this);
        this._output = new Output(this);
        this._popen = new POpen(this);
        this._read = new Read(this);
        this._tmpfile = new TmpFile(this);
        this._write = new Write(this);
    }

    public static void installInto(StateContext context, Table env, RuntimeEnvironment runtimeEnvironment) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        Table t = context.newTable();
        FileSystem fileSystem = runtimeEnvironment != null ? runtimeEnvironment.fileSystem() : null;
        InputStream in = runtimeEnvironment != null ? runtimeEnvironment.standardInput() : null;
        OutputStream out = runtimeEnvironment != null ? runtimeEnvironment.standardOutput() : null;
        OutputStream err = runtimeEnvironment != null ? runtimeEnvironment.standardError() : null;
        IoLib l = new IoLib(context, fileSystem, in, out, err);
        t.rawset("close", (Object)l._close);
        t.rawset("flush", (Object)l._flush);
        t.rawset("input", (Object)l._input);
        t.rawset("lines", (Object)l._lines);
        t.rawset("open", (Object)l._open);
        t.rawset("output", (Object)l._output);
        t.rawset("popen", (Object)l._popen);
        t.rawset("read", (Object)l._read);
        t.rawset("tmpfile", (Object)l._tmpfile);
        t.rawset("type", (Object)IoLib.type());
        t.rawset("write", (Object)l._write);
        t.rawset("stdin", (Object)l.stdIn);
        t.rawset("stdout", (Object)l.stdOut);
        t.rawset("stderr", (Object)l.stdErr);
        ModuleLib.install(env, "io", t);
    }

    private IoFile openFile(ByteString filename, Open.Mode mode) {
        Objects.requireNonNull(filename);
        Objects.requireNonNull(mode);
        if (this.fileSystem == null) {
            throw new UnsupportedOperationException("no filesystem");
        }
        Path path = this.fileSystem.getPath(filename.toString(), new String[0]);
        throw new UnsupportedOperationException("open file");
    }

    private IoFile setDefaultInputFile(IoFile f) {
        this.defaultInput = Objects.requireNonNull(f);
        return f;
    }

    private IoFile getDefaultInputFile() {
        return this.defaultInput;
    }

    private IoFile setDefaultOutputFile(IoFile f) {
        this.defaultOutput = Objects.requireNonNull(f);
        return f;
    }

    private IoFile getDefaultOutputFile() {
        return this.defaultOutput;
    }

    static class Write
    extends AbstractLibFunction {
        private final IoLib lib;

        public Write(IoLib lib) {
            this.lib = Objects.requireNonNull(lib);
        }

        @Override
        protected String name() {
            return "write";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile file = this.lib.getDefaultOutputFile();
            ArrayList<Object> callArgs = new ArrayList<Object>();
            callArgs.add(file);
            callArgs.addAll(Arrays.asList(args.copyAll()));
            try {
                Dispatch.call(context, (Object)IoLib.file_write(), callArgs.toArray());
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, null);
            }
            this.resume(context, file);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
        }
    }

    static class TmpFile
    extends UnimplementedFunction {
        public TmpFile(IoLib lib) {
            super("io.tmpfile");
        }
    }

    static class Type
    extends AbstractLibFunction {
        Type() {
        }

        @Override
        protected String name() {
            return "type";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile f;
            Object o = args.nextAny();
            String result = o instanceof IoFile ? ((f = (IoFile)o).isClosed() ? "closed file" : "file") : null;
            context.getReturnBuffer().setTo(result);
        }
    }

    static class Read
    extends AbstractLibFunction {
        private final IoLib lib;

        public Read(IoLib lib) {
            this.lib = Objects.requireNonNull(lib);
        }

        @Override
        protected String name() {
            return "read";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile file = this.lib.getDefaultInputFile();
            ArrayList<Object> callArgs = new ArrayList<Object>();
            callArgs.add(file);
            callArgs.addAll(Arrays.asList(args.copyAll()));
            try {
                Dispatch.call(context, (Object)IoLib.file_read(), callArgs.toArray());
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, null);
            }
            this.resume(context, file);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
        }
    }

    static class POpen
    extends UnimplementedFunction {
        public POpen(IoLib lib) {
            super("io.popen");
        }
    }

    static class Output
    extends AbstractLibFunction {
        private final IoLib lib;

        public Output(IoLib lib) {
            this.lib = Objects.requireNonNull(lib);
        }

        @Override
        protected String name() {
            return "output";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            if (args.hasNext()) {
                ByteString filename = args.nextString();
                IoFile f = this.lib.openFile(filename, Open.Mode.WRITE);
                assert (f != null);
                this.lib.setDefaultOutputFile(f);
                context.getReturnBuffer().setTo(f);
            } else {
                IoFile outFile = this.lib.getDefaultOutputFile();
                context.getReturnBuffer().setTo(outFile);
            }
        }
    }

    static class Open
    extends AbstractLibFunction {
        private final IoLib lib;
        private static final Mode DEFAULT_MODE = Mode.READ;

        public Open(IoLib lib) {
            this.lib = Objects.requireNonNull(lib);
        }

        private static Mode mode(String modeString) {
            switch (modeString) {
                case "r": {
                    return Mode.READ;
                }
                case "w": {
                    return Mode.WRITE;
                }
                case "a": {
                    return Mode.APPEND;
                }
                case "r+": {
                    return Mode.UPDATE_READ;
                }
                case "w+": {
                    return Mode.UPDATE_WRITE;
                }
                case "a+": {
                    return Mode.UPDATE_APPEND;
                }
            }
            return null;
        }

        @Override
        protected String name() {
            return "open";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Mode mode;
            String modeString;
            ByteString filename = args.nextString();
            String string = modeString = args.hasNext() ? args.nextString().toString() : null;
            if (modeString != null) {
                if (modeString.endsWith("b")) {
                    boolean binary = true;
                    modeString = modeString.substring(0, modeString.length() - 1);
                } else {
                    boolean binary = false;
                }
                mode = Open.mode(modeString);
            } else {
                mode = DEFAULT_MODE;
                boolean binary = false;
            }
            if (mode == null) {
                throw new BadArgumentException(1, this.name(), "invalid mode");
            }
            IoFile file = null;
            try {
                file = this.lib.openFile(filename, mode);
            }
            catch (Exception ex) {
                context.getReturnBuffer().setTo(null, ex.getMessage());
                return;
            }
            assert (file != null);
            context.getReturnBuffer().setTo(file);
        }

        static enum Mode {
            READ,
            WRITE,
            APPEND,
            UPDATE_READ,
            UPDATE_WRITE,
            UPDATE_APPEND;

        }
    }

    static class Lines
    extends UnimplementedFunction {
        public Lines(IoLib lib) {
            super("io.lines");
        }
    }

    static class Input
    extends AbstractLibFunction {
        private final IoLib lib;

        public Input(IoLib lib) {
            this.lib = Objects.requireNonNull(lib);
        }

        @Override
        protected String name() {
            return "input";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            if (args.hasNext()) {
                ByteString filename = args.nextString();
                IoFile f = this.lib.openFile(filename, Open.Mode.READ);
                assert (f != null);
                this.lib.setDefaultInputFile(f);
                context.getReturnBuffer().setTo(f);
            } else {
                IoFile inFile = this.lib.getDefaultInputFile();
                context.getReturnBuffer().setTo(inFile);
            }
        }
    }

    static class Flush
    extends AbstractLibFunction {
        private final IoLib lib;

        public Flush(IoLib lib) {
            this.lib = Objects.requireNonNull(lib);
        }

        @Override
        protected String name() {
            return "flush";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile outFile = this.lib.getDefaultOutputFile();
            try {
                Dispatch.call(context, IoLib.file_flush());
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, outFile);
            }
            this.resume(context, outFile);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
        }
    }

    static class Close
    extends AbstractLibFunction {
        private final IoLib lib;

        public Close(IoLib lib) {
            this.lib = Objects.requireNonNull(lib);
        }

        @Override
        protected String name() {
            return "close";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            IoFile file = args.hasNext() ? args.nextUserdata(IoFile.typeName(), IoFile.class) : this.lib.getDefaultOutputFile();
            try {
                Dispatch.call(context, (Object)IoLib.file_close(), file);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, null);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
        }
    }
}

