/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.classdump.luna.parser.analysis.FunctionVarInfo;
import org.classdump.luna.parser.analysis.FunctionVarInfoBuilder;
import org.classdump.luna.parser.analysis.ResolvedVariable;
import org.classdump.luna.parser.analysis.VarMapping;
import org.classdump.luna.parser.analysis.Variable;
import org.classdump.luna.parser.ast.Attributes;
import org.classdump.luna.parser.ast.Block;
import org.classdump.luna.parser.ast.BodyStatement;
import org.classdump.luna.parser.ast.Chunk;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.FunctionDefExpr;
import org.classdump.luna.parser.ast.GenericForStatement;
import org.classdump.luna.parser.ast.IndexExpr;
import org.classdump.luna.parser.ast.LValueExpr;
import org.classdump.luna.parser.ast.LiteralExpr;
import org.classdump.luna.parser.ast.LocalDeclStatement;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.NumericForStatement;
import org.classdump.luna.parser.ast.RepeatUntilStatement;
import org.classdump.luna.parser.ast.StringLiteral;
import org.classdump.luna.parser.ast.Transformer;
import org.classdump.luna.parser.ast.VarExpr;
import org.classdump.luna.parser.ast.VarargsExpr;

class NameResolutionTransformer
extends Transformer {
    private FunctionVarInfoBuilder fnScope;

    public NameResolutionTransformer(FunctionVarInfoBuilder fnScope) {
        this.fnScope = fnScope;
    }

    public NameResolutionTransformer() {
        this(null);
    }

    protected void enterFunction() {
        this.fnScope = new FunctionVarInfoBuilder(this.fnScope);
    }

    protected FunctionVarInfo leaveFunction() {
        FunctionVarInfoBuilder scope = this.fnScope;
        this.fnScope = scope.parent();
        return scope.toVarInfo();
    }

    @Override
    public Chunk transform(Chunk chunk) {
        this.enterFunction();
        Chunk c = chunk.update(this.transform(chunk.block()));
        FunctionVarInfo varInfo = this.leaveFunction();
        return c.with(varInfo);
    }

    @Override
    public Block transform(Block block) {
        this.fnScope.enterBlock();
        Block b = super.transform(block);
        this.fnScope.leaveBlock();
        return b;
    }

    @Override
    public BodyStatement transform(LocalDeclStatement node) {
        List<Expr> resolvedInitialisers = this.transformExprList(node.initialisers());
        List<Name> ns = this.transformNameList(node.names());
        ArrayList<Variable> vs = new ArrayList<Variable>();
        for (Name n : ns) {
            Variable v = this.fnScope.addLocal(n);
            vs.add(v);
        }
        return node.update(ns, resolvedInitialisers).with(new VarMapping(Collections.unmodifiableList(vs)));
    }

    @Override
    public BodyStatement transform(NumericForStatement node) {
        Name n = this.transform(node.name());
        Expr init = node.init().accept(this);
        Expr limit = node.limit().accept(this);
        Expr step = node.step() != null ? node.step().accept(this) : null;
        this.fnScope.enterBlock();
        Variable v = this.fnScope.addLocal(n);
        node = node.update(n, init, limit, step, this.transform(node.block()));
        node = node.with(new VarMapping(v));
        this.fnScope.leaveBlock();
        return node;
    }

    @Override
    public BodyStatement transform(GenericForStatement node) {
        List<Name> ns = this.transformNameList(node.names());
        List<Expr> es = this.transformExprList(node.exprs());
        ArrayList<Variable> vs = new ArrayList<Variable>();
        this.fnScope.enterBlock();
        for (Name n : ns) {
            Variable v = this.fnScope.addLocal(n);
            vs.add(v);
        }
        node = node.update(ns, es, this.transform(node.block()));
        node = node.with(new VarMapping(Collections.unmodifiableList(vs)));
        this.fnScope.leaveBlock();
        return node;
    }

    @Override
    public BodyStatement transform(RepeatUntilStatement node) {
        this.fnScope.enterBlock();
        Block b = super.transform(node.block());
        Expr c = node.condition().accept(this);
        node = node.update(c, b);
        this.fnScope.leaveBlock();
        return node;
    }

    @Override
    public FunctionDefExpr transform(FunctionDefExpr e) {
        this.enterFunction();
        this.fnScope.enterBlock();
        FunctionDefExpr.Params ps = this.transform(e.params());
        for (Name n : ps.names()) {
            this.fnScope.addParam(n);
        }
        e = e.update(ps, this.transform(e.block()));
        this.fnScope.leaveBlock();
        FunctionVarInfo varInfo = this.leaveFunction();
        e = e.with(varInfo);
        if (!ps.isVararg() && varInfo.isVararg()) {
            throw new IllegalStateException("cannot use '...' outside a vararg function");
        }
        return e;
    }

    @Override
    public LValueExpr transform(VarExpr e) {
        if (e.attributes().has(ResolvedVariable.class)) {
            throw new IllegalStateException("variable already resolved: " + e.name() + " -> " + e.attributes().get(ResolvedVariable.class));
        }
        ResolvedVariable bound = this.fnScope.resolve(e.name());
        if (bound != null) {
            return e.with(bound);
        }
        ResolvedVariable env = this.fnScope.resolve(Variable.ENV_NAME);
        assert (env != null);
        Attributes attr = e.attributes();
        return new IndexExpr(attr, new VarExpr(attr.with(env), Variable.ENV_NAME), new LiteralExpr(attr, StringLiteral.fromName(e.name())));
    }

    @Override
    public Expr transform(VarargsExpr e) {
        this.fnScope.setVararg();
        return super.transform(e);
    }
}

