/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.List;
import java.util.Objects;
import org.classdump.luna.parser.ast.Attributes;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.Transformer;

public class TableConstructorExpr
extends Expr {
    private final List<FieldInitialiser> fields;

    public TableConstructorExpr(Attributes attr, List<FieldInitialiser> fields) {
        super(attr);
        this.fields = Objects.requireNonNull(fields);
    }

    public List<FieldInitialiser> fields() {
        return this.fields;
    }

    public TableConstructorExpr update(List<FieldInitialiser> fields) {
        if (this.fields.equals(fields)) {
            return this;
        }
        return new TableConstructorExpr(this.attributes(), fields);
    }

    @Override
    public Expr accept(Transformer tf) {
        return tf.transform(this);
    }

    public static class FieldInitialiser {
        private final Expr keyExpr;
        private final Expr valueExpr;

        public FieldInitialiser(Expr keyExpr, Expr valueExpr) {
            this.keyExpr = keyExpr;
            this.valueExpr = Objects.requireNonNull(valueExpr);
        }

        public Expr key() {
            return this.keyExpr;
        }

        public Expr value() {
            return this.valueExpr;
        }

        public FieldInitialiser update(Expr keyExpr, Expr valueExpr) {
            if (Objects.equals(this.keyExpr, keyExpr) && this.valueExpr.equals(valueExpr)) {
                return this;
            }
            return new FieldInitialiser(keyExpr, valueExpr);
        }
    }
}

