/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.util;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.LuaFormat;
import org.classdump.luna.parser.analysis.FunctionVarInfo;
import org.classdump.luna.parser.analysis.ResolvedLabel;
import org.classdump.luna.parser.analysis.ResolvedVariable;
import org.classdump.luna.parser.analysis.VarMapping;
import org.classdump.luna.parser.analysis.Variable;
import org.classdump.luna.parser.ast.AssignStatement;
import org.classdump.luna.parser.ast.BinaryOperationExpr;
import org.classdump.luna.parser.ast.Block;
import org.classdump.luna.parser.ast.BodyStatement;
import org.classdump.luna.parser.ast.BooleanLiteral;
import org.classdump.luna.parser.ast.BreakStatement;
import org.classdump.luna.parser.ast.CallExpr;
import org.classdump.luna.parser.ast.CallStatement;
import org.classdump.luna.parser.ast.ConditionalBlock;
import org.classdump.luna.parser.ast.DoStatement;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.FunctionDefExpr;
import org.classdump.luna.parser.ast.GenericForStatement;
import org.classdump.luna.parser.ast.GotoStatement;
import org.classdump.luna.parser.ast.IfStatement;
import org.classdump.luna.parser.ast.IndexExpr;
import org.classdump.luna.parser.ast.LValueExpr;
import org.classdump.luna.parser.ast.LabelStatement;
import org.classdump.luna.parser.ast.LiteralExpr;
import org.classdump.luna.parser.ast.LocalDeclStatement;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.NilLiteral;
import org.classdump.luna.parser.ast.Numeral;
import org.classdump.luna.parser.ast.NumericForStatement;
import org.classdump.luna.parser.ast.Operator;
import org.classdump.luna.parser.ast.ParenExpr;
import org.classdump.luna.parser.ast.RepeatUntilStatement;
import org.classdump.luna.parser.ast.ReturnStatement;
import org.classdump.luna.parser.ast.StringLiteral;
import org.classdump.luna.parser.ast.TableConstructorExpr;
import org.classdump.luna.parser.ast.UnaryOperationExpr;
import org.classdump.luna.parser.ast.VarExpr;
import org.classdump.luna.parser.ast.VarargsExpr;
import org.classdump.luna.parser.ast.Visitor;
import org.classdump.luna.parser.ast.WhileStatement;

public class FormattingPrinterVisitor
extends Visitor {
    private final PrintWriter out;
    private final String indentString;
    private final int indent;
    private final boolean withResolvedNames;

    FormattingPrinterVisitor(PrintWriter out, String indentString, int indent, boolean withResolvedNames) {
        this.out = Objects.requireNonNull(out);
        this.indentString = Objects.requireNonNull(indentString);
        this.indent = indent;
        this.withResolvedNames = withResolvedNames;
    }

    public FormattingPrinterVisitor(PrintWriter out, boolean withResolvedNames) {
        this(out, "\t", 0, withResolvedNames);
    }

    public FormattingPrinterVisitor(PrintWriter out) {
        this(out, false);
    }

    private void doIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(this.indentString);
        }
    }

    private FormattingPrinterVisitor subVisitor() {
        return new FormattingPrinterVisitor(this.out, this.indentString, this.indent + 1, this.withResolvedNames);
    }

    private static <T> T getOrNull(List<T> list, int idx) {
        return list != null && idx >= 0 && idx < list.size() ? (T)list.get(idx) : null;
    }

    private static Variable mappedVar(VarMapping vm, int idx) {
        return vm != null ? FormattingPrinterVisitor.getOrNull(vm.vars(), idx) : null;
    }

    private String varNameToString(Name n, Variable v) {
        if (this.withResolvedNames) {
            return v == null ? "_unresolved_" + n.value() : v.name().value() + "_" + Integer.toHexString(v.hashCode());
        }
        return n.value();
    }

    private void printName(Name n, Variable v) {
        this.out.print(this.varNameToString(n, v));
    }

    private void printName(Name n, ResolvedVariable rv) {
        String result = this.withResolvedNames ? (rv == null ? this.varNameToString(n, null) : (rv.isUpvalue() ? "--[[^]]" : "") + this.varNameToString(n, rv.variable())) : n.value();
        this.out.print(result);
    }

    private void printLabelName(Name n, ResolvedLabel rl) {
        String result = this.withResolvedNames ? (rl == null ? "_unresolved_" + n.value() : n.value() + "_" + Integer.toHexString(rl.hashCode())) : n.value();
        this.out.print(result);
    }

    private void printExpr(Expr expr) {
        expr.accept(this);
    }

    private void printVarExpr(Expr expr) {
        if (expr instanceof LValueExpr) {
            this.printExpr(expr);
        } else {
            this.out.print("(");
            this.printExpr(expr);
            this.out.print(")");
        }
    }

    private <T extends Expr> void printExprList(Iterable<T> args) {
        Iterator<T> it = args.iterator();
        while (it.hasNext()) {
            ((Expr)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.out.print(", ");
        }
    }

    private void printNameList(Iterable<Name> names, List<Variable> vars) {
        Iterator<Name> it = names.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.printName(it.next(), FormattingPrinterVisitor.getOrNull(vars, i++));
            if (!it.hasNext()) continue;
            this.out.print(", ");
        }
    }

    private void printNameList(Iterable<Name> names, VarMapping varMapping) {
        this.printNameList(names, varMapping != null ? varMapping.vars() : null);
    }

    private void printFixedParamList(Iterable<Name> names, FunctionVarInfo fvi) {
        this.printNameList(names, fvi != null ? fvi.params() : null);
    }

    @Override
    public void visit(Block block) {
        for (BodyStatement s : block.statements()) {
            s.accept(this);
        }
        if (block.returnStatement() != null) {
            block.returnStatement().accept(this);
        }
    }

    @Override
    public void visit(DoStatement node) {
        this.doIndent();
        this.out.println("do");
        this.visit(node.block());
        this.doIndent();
        this.out.println("end");
    }

    @Override
    public void visit(ReturnStatement node) {
        this.doIndent();
        this.out.print("return ");
        this.printExprList(node.exprs());
        this.out.println();
    }

    @Override
    public void visit(CallStatement node) {
        this.doIndent();
        node.callExpr().accept(this);
        this.out.println();
    }

    @Override
    public void visit(AssignStatement node) {
        this.doIndent();
        this.printExprList(node.vars());
        this.out.print(" = ");
        this.printExprList(node.exprs());
        this.out.println();
    }

    @Override
    public void visit(LocalDeclStatement node) {
        this.doIndent();
        this.out.print("local ");
        this.printNameList(node.names(), node.attributes().get(VarMapping.class));
        if (!node.initialisers().isEmpty()) {
            this.out.print(" = ");
            this.printExprList(node.initialisers());
        }
        this.out.println();
    }

    private void printConditionalBlock(ConditionalBlock cbl) {
        this.printExpr(cbl.condition());
        this.out.println(" then");
        this.subVisitor().visit(cbl.block());
    }

    @Override
    public void visit(IfStatement node) {
        this.doIndent();
        this.out.print("if ");
        this.printConditionalBlock(node.main());
        for (ConditionalBlock cbl : node.elifs()) {
            this.doIndent();
            this.out.print("elseif ");
            this.printConditionalBlock(cbl);
        }
        if (node.elseBlock() != null) {
            this.doIndent();
            this.out.print("else");
            this.subVisitor().visit(node.elseBlock());
        }
        this.doIndent();
        this.out.println("end");
    }

    @Override
    public void visit(NumericForStatement node) {
        this.doIndent();
        this.out.print("for ");
        this.printName(node.name(), FormattingPrinterVisitor.mappedVar(node.attributes().get(VarMapping.class), 0));
        this.out.print(" = ");
        this.printExpr(node.init());
        this.out.print(", ");
        this.printExpr(node.limit());
        if (node.step() != null) {
            this.out.print(", ");
            this.printExpr(node.step());
        }
        this.out.println(" do");
        this.subVisitor().visit(node.block());
        this.doIndent();
        this.out.println("end");
    }

    @Override
    public void visit(GenericForStatement node) {
        this.doIndent();
        this.out.print("for ");
        this.printNameList(node.names(), node.attributes().get(VarMapping.class));
        this.out.print(" in ");
        this.printExprList(node.exprs());
        this.out.println(" do");
        this.subVisitor().visit(node.block());
        this.doIndent();
        this.out.println("end");
    }

    @Override
    public void visit(WhileStatement node) {
        this.doIndent();
        this.out.print("while ");
        this.printExpr(node.condition());
        this.out.println(" do");
        this.subVisitor().visit(node.block());
        this.doIndent();
        this.out.println("end");
    }

    @Override
    public void visit(RepeatUntilStatement node) {
        this.doIndent();
        this.out.println("repeat");
        this.subVisitor().visit(node.block());
        this.doIndent();
        this.out.print("until ");
        this.printExpr(node.condition());
        this.out.println();
    }

    @Override
    public void visit(BreakStatement node) {
        this.doIndent();
        this.out.println("break");
    }

    @Override
    public void visit(GotoStatement node) {
        this.doIndent();
        this.out.print("goto ");
        this.printLabelName(node.labelName(), node.attributes().get(ResolvedLabel.class));
        this.out.println();
    }

    @Override
    public void visit(LabelStatement node) {
        this.doIndent();
        this.out.print("::");
        this.printLabelName(node.labelName(), node.attributes().get(ResolvedLabel.class));
        this.out.println("::");
    }

    @Override
    public void visit(VarExpr node) {
        this.printName(node.name(), node.attributes().get(ResolvedVariable.class));
    }

    @Override
    public void visit(IndexExpr node) {
        this.printVarExpr(node.object());
        this.out.print("[");
        this.printExpr(node.key());
        this.out.print("]");
    }

    @Override
    public void visit(CallExpr.FunctionCallExpr node) {
        this.printVarExpr(node.fn());
        this.out.print("(");
        this.printExprList(node.args());
        this.out.print(")");
    }

    @Override
    public void visit(CallExpr.MethodCallExpr node) {
        this.printVarExpr(node.target());
        this.out.print(":");
        this.out.print(node.methodName().value());
        this.out.print("(");
        this.printExprList(node.args());
        this.out.print(")");
    }

    @Override
    public void visit(FunctionDefExpr node) {
        this.out.print("function ");
        this.out.print("(");
        this.printFixedParamList(node.params().names(), node.attributes().get(FunctionVarInfo.class));
        if (node.params().isVararg()) {
            if (!node.params().names().isEmpty()) {
                this.out.print(", ");
            }
            this.out.print("...");
        }
        this.out.print(")");
        this.out.println();
        this.subVisitor().visit(node.block());
        this.doIndent();
        this.out.print("end");
    }

    @Override
    public void visit(LiteralExpr node) {
        node.value().accept(this);
    }

    @Override
    public void visit(TableConstructorExpr node) {
        this.out.print("{");
        Iterator<TableConstructorExpr.FieldInitialiser> it = node.fields().iterator();
        while (it.hasNext()) {
            TableConstructorExpr.FieldInitialiser fi = it.next();
            Expr k = fi.key();
            if (k != null) {
                this.out.print("[");
                this.printExpr(k);
                this.out.print("] = ");
            }
            this.printExpr(fi.value());
            if (!it.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.print("}");
    }

    @Override
    public void visit(VarargsExpr node) {
        this.out.print("...");
    }

    @Override
    public void visit(ParenExpr node) {
        this.out.print("(");
        node.multiExpr().accept(this);
        this.out.print(")");
    }

    private static String binOp(Operator.Binary op) {
        switch (op) {
            case ADD: {
                return "+";
            }
            case SUB: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case IDIV: {
                return "//";
            }
            case MOD: {
                return "%";
            }
            case POW: {
                return "^";
            }
            case CONCAT: {
                return "..";
            }
            case BAND: {
                return "&";
            }
            case BOR: {
                return "|";
            }
            case BXOR: {
                return "~";
            }
            case SHL: {
                return "<<";
            }
            case SHR: {
                return ">>";
            }
            case EQ: {
                return "==";
            }
            case NEQ: {
                return "~=";
            }
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
            case AND: {
                return "and";
            }
            case OR: {
                return "or";
            }
        }
        throw new IllegalArgumentException("Illegal operator: " + op);
    }

    @Override
    public void visit(BinaryOperationExpr node) {
        this.out.print("(");
        this.printExpr(node.left());
        this.out.print(" ");
        this.out.print(FormattingPrinterVisitor.binOp(node.op()));
        this.out.print(" ");
        this.printExpr(node.right());
        this.out.print(")");
    }

    private static String unOp(Operator.Unary op) {
        switch (op) {
            case UNM: {
                return "-";
            }
            case BNOT: {
                return "~";
            }
            case LEN: {
                return "#";
            }
            case NOT: {
                return "not ";
            }
        }
        throw new IllegalArgumentException("Illegal operator: " + op);
    }

    @Override
    public void visit(UnaryOperationExpr node) {
        this.out.print("(");
        this.out.print(FormattingPrinterVisitor.unOp(node.op()));
        this.printExpr(node.arg());
        this.out.print(")");
    }

    @Override
    public void visit(NilLiteral node) {
        this.out.print(LuaFormat.NIL);
    }

    @Override
    public void visit(BooleanLiteral node) {
        this.out.print(LuaFormat.toString(node.value()));
    }

    @Override
    public void visit(Numeral.IntegerNumeral node) {
        this.out.print(LuaFormat.toString(node.value()));
    }

    @Override
    public void visit(Numeral.FloatNumeral node) {
        this.out.print(LuaFormat.toString(node.value()));
    }

    @Override
    public void visit(StringLiteral node) {
        this.out.print(LuaFormat.escape(node.value()));
    }
}

