/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.runtime;

import java.util.Objects;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.Errors;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.IllegalCoroutineStateException;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.Resumable;
import org.classdump.luna.runtime.ResumeInfo;
import org.classdump.luna.runtime.UnresolvedControlThrowable;
import org.classdump.luna.util.Cons;

public final class Coroutine {
    private Cons<ResumeInfo> callStack;
    private Status status;

    Coroutine(Object body) {
        this.callStack = new Cons<ResumeInfo>(new ResumeInfo(BootstrapResumable.INSTANCE, body));
        this.status = Status.SUSPENDED;
    }

    synchronized Status getStatus() {
        return this.status;
    }

    static Cons<ResumeInfo> _resume(Coroutine a, Coroutine b, Cons<ResumeInfo> cs) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Objects.requireNonNull(cs);
        Coroutine coroutine = a;
        synchronized (coroutine) {
            if (a.status == Status.RUNNING) {
                Coroutine coroutine2 = b;
                synchronized (coroutine2) {
                    if (b.status == Status.SUSPENDED) {
                        Cons<ResumeInfo> result = b.callStack;
                        a.callStack = cs;
                        b.callStack = null;
                        a.status = Status.NORMAL;
                        b.status = Status.RUNNING;
                        return result;
                    }
                    if (b.status == Status.DEAD) {
                        throw Errors.resumeDeadCoroutine();
                    }
                    throw Errors.resumeNonSuspendedCoroutine();
                }
            }
            throw new IllegalStateException("resuming coroutine not in running state");
        }
    }

    static Cons<ResumeInfo> _yield(Coroutine a, Coroutine b, Cons<ResumeInfo> cs) {
        Coroutine coroutine = a;
        synchronized (coroutine) {
            if (a.status == Status.NORMAL) {
                Coroutine coroutine2 = b;
                synchronized (coroutine2) {
                    if (b.status == Status.RUNNING) {
                        Cons<ResumeInfo> result = a.callStack;
                        a.callStack = null;
                        b.callStack = cs;
                        a.status = Status.RUNNING;
                        b.status = b.callStack != null ? Status.SUSPENDED : Status.DEAD;
                        return result;
                    }
                    throw new IllegalCoroutineStateException("yielding coroutine not in running state");
                }
            }
            throw new IllegalCoroutineStateException("yielding coroutine not in normal state");
        }
    }

    static Cons<ResumeInfo> _return(Coroutine a, Coroutine b) {
        return Coroutine._yield(a, b, null);
    }

    synchronized Cons<ResumeInfo> unpause() {
        this.status = Status.RUNNING;
        Cons<ResumeInfo> result = this.callStack;
        this.callStack = null;
        return result;
    }

    synchronized void pause(Cons<ResumeInfo> callStack) {
        this.callStack = callStack;
    }

    private static class BootstrapResumable
    implements Resumable {
        static final BootstrapResumable INSTANCE = new BootstrapResumable();

        private BootstrapResumable() {
        }

        @Override
        public void resume(ExecutionContext context, Object target) throws ResolvedControlThrowable {
            try {
                Dispatch.call(context, target, context.getReturnBuffer().getAsArray());
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve();
            }
        }
    }

    public static enum Status {
        SUSPENDED,
        RUNNING,
        NORMAL,
        DEAD;

    }
}

