/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class TraversableHashMap<K, V>
implements Map<K, V> {
    private final HashMap<K, Entry<K, V>> entries = new HashMap();
    private K firstKey = null;
    private K lastKey = null;
    private final Set<K> keySet = new KeySet();
    private final Collection<V> values = new Values();
    private final Set<Map.Entry<K, V>> entrySet = new EntrySet();

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entries.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (Entry<K, V> e : this.entries.values()) {
            if (!value.equals(e.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> e = this.entries.get(key);
        return e != null ? (V)e.getValue() : null;
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        Entry<K, V> e = this.entries.get(key);
        if (e == null) {
            this.entries.put(key, new Entry<Object, V>(value, this.lastKey, null));
            if (this.lastKey != null) {
                this.entries.get(this.lastKey).setNextKey(key);
            }
            this.lastKey = key;
            if (this.firstKey == null) {
                this.firstKey = key;
            }
            return null;
        }
        return e.setValue(value);
    }

    @Override
    public V remove(Object key) {
        Objects.requireNonNull(key, "key is null");
        Entry<K, V> e = this.entries.remove(key);
        if (e != null) {
            K prevKey = e.getPreviousKey();
            K nextKey = e.getNextKey();
            if (prevKey != null) {
                this.entries.get(prevKey).setNextKey(nextKey);
            } else {
                this.firstKey = nextKey;
            }
            if (nextKey != null) {
                this.entries.get(nextKey).setPreviousKey(prevKey);
            } else {
                this.lastKey = prevKey;
            }
            return e.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.entries.clear();
        this.firstKey = null;
        this.lastKey = null;
    }

    public K getFirstKey() {
        return this.firstKey;
    }

    public K getLastKey() {
        return this.lastKey;
    }

    public K getSuccessorOf(K key) {
        Objects.requireNonNull(key);
        Entry<K, V> e = this.entries.get(key);
        if (e == null) {
            throw new NoSuchElementException(key.toString());
        }
        return e.getNextKey();
    }

    public K getPredecessorOf(K key) {
        Objects.requireNonNull(key);
        Entry<K, V> e = this.entries.get(key);
        if (e == null) {
            throw new NoSuchElementException(key.toString());
        }
        return e.getPreviousKey();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapEntryIterator();
        }

        @Override
        public int size() {
            return TraversableHashMap.this.size();
        }

        @Override
        public void clear() {
            TraversableHashMap.this.clear();
        }
    }

    private class MapEntryIterator
    extends AbstractEntryIterator<Map.Entry<K, V>> {
        private MapEntryIterator() {
        }

        @Override
        protected Map.Entry<K, V> get(K k, Entry<K, V> v) {
            return new MapEntryAdapter(k, v);
        }
    }

    private static class MapEntryAdapter<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final Entry<K, V> entry;

        MapEntryAdapter(K key, Entry<K, V> entry) {
            this.key = Objects.requireNonNull(key);
            this.entry = Objects.requireNonNull(entry);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            Object thatKey = that.getKey();
            Object thatValue = that.getValue();
            return thatKey != null && thatValue != null && this.key.equals(thatKey) && this.entry.getValue().equals(thatValue);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.entry.getValue());
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return TraversableHashMap.this.size();
        }

        @Override
        public void clear() {
            TraversableHashMap.this.clear();
        }
    }

    private class ValueIterator
    extends AbstractEntryIterator<V> {
        private ValueIterator() {
        }

        @Override
        protected V get(K k, Entry<K, V> v) {
            return v.getValue();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return TraversableHashMap.this.size();
        }

        @Override
        public void clear() {
            TraversableHashMap.this.clear();
        }
    }

    private class KeyIterator
    extends AbstractEntryIterator<K> {
        private KeyIterator() {
        }

        @Override
        protected K get(K k, Entry<K, V> v) {
            return k;
        }
    }

    private abstract class AbstractEntryIterator<T>
    implements Iterator<T> {
        private K key;
        private boolean nextCalled;

        AbstractEntryIterator() {
            this.key = TraversableHashMap.this.firstKey;
            this.nextCalled = false;
        }

        @Override
        public boolean hasNext() {
            return this.key != null;
        }

        protected abstract T get(K var1, Entry<K, V> var2);

        @Override
        public T next() {
            Object k = this.key;
            Entry e = (Entry)TraversableHashMap.this.entries.get(k);
            if (e == null) {
                throw new NoSuchElementException(Objects.toString(this.key));
            }
            this.nextCalled = true;
            this.key = e.getNextKey();
            return this.get(k, e);
        }

        @Override
        public void remove() {
            Entry e = (Entry)TraversableHashMap.this.entries.remove(this.key);
            if (!this.nextCalled) {
                throw new IllegalStateException();
            }
            this.nextCalled = false;
        }
    }

    static class Entry<K, V> {
        private V value;
        private K prevKey;
        private K nextKey;

        public Entry(V value, K prevKey, K nextKey) {
            this.value = Objects.requireNonNull(value);
            this.prevKey = prevKey;
            this.nextKey = nextKey;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = Objects.requireNonNull(newValue);
            return oldValue;
        }

        public K getPreviousKey() {
            return this.prevKey;
        }

        public void setPreviousKey(K key) {
            this.prevKey = key;
        }

        public K getNextKey() {
            return this.nextKey;
        }

        public void setNextKey(K key) {
            this.nextKey = key;
        }
    }
}

