/*
 * Copyright 2016 Miroslav Janíček
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.classdump.luna.compiler.tf;

import org.classdump.luna.compiler.IRFunc;

public class CPUAccounter {

	public static IRFunc insertCPUAccounting(IRFunc fn) {
		CPUAccountingVisitor visitor = new CPUAccountingVisitor(CPUAccountingVisitor.INITIALISE);
		visitor.visit(fn);
		return fn.update(visitor.result());
  	}

	public static IRFunc collectCPUAccounting(IRFunc fn) {
		CPUAccountingVisitor visitor = new CPUAccountingVisitor(CPUAccountingVisitor.COLLECT);
		visitor.visit(fn);
		return fn.update(visitor.result());
  	}

}
