/*
 * Copyright 2016 Miroslav Janíček
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.classdump.luna.parser.ast;

import org.classdump.luna.parser.ast.Attributes;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.MultiExpr;
import org.classdump.luna.parser.ast.Transformer;

import java.util.Objects;

public class ParenExpr extends Expr {

	private final MultiExpr multiExpr;

	public ParenExpr(Attributes attr, MultiExpr multiExpr) {
		super(attr);
		this.multiExpr = Objects.requireNonNull(multiExpr);
	}

	public MultiExpr multiExpr() {
		return multiExpr;
	}

	public ParenExpr update(MultiExpr multiExpr) {
		if (this.multiExpr.equals(multiExpr)) {
			return this;
		}
		else {
			return new ParenExpr(attributes(), multiExpr);
		}
	}

	@Override
	public Expr accept(Transformer tf) {
		return tf.transform(this);
	}

}
