/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.classdump.luna.ByteString;
import org.classdump.luna.util.Check;

public class ByteStringBuilder {
    private byte[] buffer;
    private int length;
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MIN_CAPACITY = 32;

    private static int binaryCeil(int x) {
        if (x < 0) {
            return 0;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    private static int idealCapacity(int desired) {
        int ceil = ByteStringBuilder.binaryCeil(desired);
        return Math.max(ceil, 32);
    }

    private static byte[] resize(byte[] buf, int newSize) {
        assert (newSize >= buf.length);
        byte[] newBuf = new byte[newSize];
        System.arraycopy(buf, 0, newBuf, 0, buf.length);
        return newBuf;
    }

    private void ensureCapacity(int cap) {
        if (cap > this.buffer.length) {
            this.buffer = ByteStringBuilder.resize(this.buffer, ByteStringBuilder.idealCapacity(cap));
        }
    }

    private ByteStringBuilder(byte[] buffer, int length) {
        this.buffer = buffer;
        this.length = length;
    }

    public ByteStringBuilder(int capacity) {
        this(new byte[ByteStringBuilder.idealCapacity(Check.nonNegative(capacity))], 0);
    }

    public ByteStringBuilder() {
        this(new byte[32], 0);
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.length;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(newLength));
        }
        if (newLength < this.length) {
            this.length = newLength;
        } else if (newLength > this.length) {
            this.ensureCapacity(newLength);
            Arrays.fill(this.buffer, this.length, newLength, (byte)0);
        }
    }

    public void trimToSize() {
        int cap = ByteStringBuilder.idealCapacity(this.length);
        if (cap < this.capacity()) {
            this.buffer = ByteStringBuilder.resize(this.buffer, cap);
        }
    }

    public void setByteAt(int index, byte value) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.buffer[index] = value;
    }

    public ByteStringBuilder append(byte b) {
        this.ensureCapacity(this.length + 1);
        this.buffer[this.length] = b;
        ++this.length;
        return this;
    }

    public ByteStringBuilder append(byte[] array, int off, int len) {
        if (off < 0 || len < 0 || off + len > array.length) {
            throw new IndexOutOfBoundsException("off=" + off + ", len=" + len);
        }
        if (len > 0) {
            this.ensureCapacity(this.length + len);
            System.arraycopy(array, off, this.buffer, this.length, len);
            this.length += len;
        }
        return this;
    }

    public ByteStringBuilder append(byte[] array) {
        return this.append(array, 0, array.length);
    }

    public ByteStringBuilder append(ByteString string) {
        return this.append(string.getBytes());
    }

    public ByteStringBuilder append(CharSequence charSequence, Charset charset) {
        if (!charset.canEncode()) {
            throw new IllegalArgumentException("Charset cannot encode: " + charset.name());
        }
        this.append(ByteString.of(charSequence.toString(), charset));
        return this;
    }

    public ByteStringBuilder append(CharSequence charSequence) {
        return this.append(charSequence, Charset.defaultCharset());
    }

    public ByteString toByteString() {
        return ByteString.copyOf(this.buffer, 0, this.length);
    }

    public String toString() {
        return this.toByteString().toString();
    }
}

