/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import java.util.Arrays;
import org.classdump.luna.ByteString;
import org.classdump.luna.ConversionException;
import org.classdump.luna.LuaFormat;
import org.classdump.luna.LuaMathOperators;
import org.classdump.luna.LuaRuntimeException;
import org.classdump.luna.NoIntegerRepresentationException;
import org.classdump.luna.PlainValueTypeNamer;

public final class Conversions {
    private static final ByteString NULL_ERROR_MESSAGE = ByteString.constOf("(null)");

    private Conversions() {
    }

    public static Number numericalValueOf(ByteString s) {
        String trimmed = s.toString().trim();
        try {
            return LuaFormat.parseInteger(trimmed);
        }
        catch (NumberFormatException ei) {
            try {
                return LuaFormat.parseFloat(trimmed);
            }
            catch (NumberFormatException ef) {
                return null;
            }
        }
    }

    public static Number numericalValueOf(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof ByteString) {
            return Conversions.numericalValueOf((ByteString)o);
        }
        if (o instanceof String) {
            return Conversions.numericalValueOf(ByteString.of((String)o));
        }
        return null;
    }

    public static Number toNumericalValue(Object o, String name) {
        Number n = Conversions.numericalValueOf(o);
        if (n == null) {
            throw new ConversionException((name != null ? name : "value") + " must be a number");
        }
        return n;
    }

    public static Number toCanonicalNumber(Number n) {
        if (n instanceof Long || n instanceof Double) {
            return n;
        }
        if (n instanceof Float) {
            return n.doubleValue();
        }
        return n.longValue();
    }

    public static Object canonicalRepresentationOf(Object o) {
        if (o instanceof Number) {
            return Conversions.toCanonicalNumber((Number)o);
        }
        if (o instanceof String) {
            return ByteString.of((String)o);
        }
        return o;
    }

    public static Object javaRepresentationOf(Object o) {
        if (o instanceof ByteString) {
            return o.toString();
        }
        return o;
    }

    public static void toCanonicalValues(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            values[i] = Conversions.canonicalRepresentationOf(v);
        }
    }

    public static void toJavaValues(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            values[i] = Conversions.javaRepresentationOf(v);
        }
    }

    public static Object[] copyAsCanonicalValues(Object[] values) {
        values = Arrays.copyOf(values, values.length);
        Conversions.toCanonicalValues(values);
        return values;
    }

    public static Object[] copyAsJavaValues(Object[] values) {
        values = Arrays.copyOf(values, values.length);
        Conversions.toJavaValues(values);
        return values;
    }

    public static Number normaliseKey(Number n) {
        Long i = Conversions.integerValueOf(n);
        return i != null ? (Number)i : (Number)Conversions.toCanonicalNumber(n);
    }

    public static Object normaliseKey(Object o) {
        if (o instanceof Number) {
            return Conversions.normaliseKey((Number)o);
        }
        if (o instanceof String) {
            return ByteString.of((String)o);
        }
        return o;
    }

    public static Number arithmeticValueOf(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        Number n = Conversions.numericalValueOf(o);
        return n != null ? Conversions.floatValueOf(n) : null;
    }

    public static Long integerValueOf(Number n) {
        if (n instanceof Double || n instanceof Float) {
            double d = n.doubleValue();
            return LuaMathOperators.hasExactIntegerRepresentation(d) ? Long.valueOf((long)d) : null;
        }
        if (n instanceof Long) {
            return (Long)n;
        }
        return n.longValue();
    }

    public static long toIntegerValue(Number n) {
        Long l = Conversions.integerValueOf(n);
        if (l != null) {
            return l;
        }
        throw new NoIntegerRepresentationException();
    }

    public static Long integerValueOf(Object o) {
        Number n = Conversions.numericalValueOf(o);
        return n != null ? Conversions.integerValueOf(n) : null;
    }

    public static long toIntegerValue(Object o) {
        Long l = Conversions.integerValueOf(o);
        if (l != null) {
            return l;
        }
        throw new NoIntegerRepresentationException();
    }

    public static Double floatValueOf(Number n) {
        return n instanceof Double ? (Double)n : Double.valueOf(n.doubleValue());
    }

    public static Double floatValueOf(Object o) {
        Number n = Conversions.numericalValueOf(o);
        return n != null ? Conversions.floatValueOf(n) : null;
    }

    public static boolean booleanValueOf(Object o) {
        return o != null && (!(o instanceof Boolean) || (Boolean)o != false);
    }

    public static ByteString stringValueOf(Number n) {
        if (n instanceof Double || n instanceof Float) {
            return LuaFormat.toByteString(n.doubleValue());
        }
        return LuaFormat.toByteString(n.longValue());
    }

    public static ByteString stringValueOf(Object o) {
        if (o instanceof ByteString) {
            return (ByteString)o;
        }
        if (o instanceof Number) {
            return Conversions.stringValueOf((Number)o);
        }
        if (o instanceof String) {
            return ByteString.of((String)o);
        }
        return null;
    }

    public static ByteString toHumanReadableString(Object o) {
        if (o == null) {
            return LuaFormat.NIL;
        }
        if (o instanceof ByteString) {
            return (ByteString)o;
        }
        if (o instanceof Number) {
            return Conversions.stringValueOf((Number)o);
        }
        if (o instanceof Boolean) {
            return LuaFormat.toByteString((Boolean)o);
        }
        if (o instanceof String) {
            return ByteString.of((String)o);
        }
        return ByteString.of(String.format("%s: %#010x", PlainValueTypeNamer.INSTANCE.typeNameOf(o), o.hashCode()));
    }

    public static Object toErrorObject(Throwable t) {
        if (t instanceof LuaRuntimeException) {
            return ((LuaRuntimeException)t).getErrorObject();
        }
        return t.getMessage();
    }

    public static ByteString toErrorMessage(Throwable t) {
        ByteString m = Conversions.stringValueOf(Conversions.toErrorObject(t));
        return m != null ? m : NULL_ERROR_MESSAGE;
    }
}

