/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

public final class LuaMathOperators {
    private static final double MAX_LONG_AS_DOUBLE = 9.223372036854776E18;
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;

    private LuaMathOperators() {
    }

    public static long add(long a, long b) {
        return a + b;
    }

    public static double add(double a, double b) {
        return a + b;
    }

    public static long sub(long a, long b) {
        return a - b;
    }

    public static double sub(double a, double b) {
        return a - b;
    }

    public static long mul(long a, long b) {
        return a * b;
    }

    public static double mul(double a, double b) {
        return a * b;
    }

    public static double div(long a, long b) {
        return (double)a / (double)b;
    }

    public static double div(double a, double b) {
        return a / b;
    }

    public static long mod(long a, long b) {
        if (b == 0L) {
            throw new ArithmeticException("attempt to perform 'n%0'");
        }
        return a - b * (long)Math.floor((double)a / (double)b);
    }

    public static double mod(double a, double b) {
        return b != 0.0 ? a - b * Math.floor(a / b) : Double.NaN;
    }

    public static long idiv(long a, long b) {
        if (b == 0L) {
            throw new ArithmeticException("attempt to divide by zero");
        }
        long q = a / b;
        return q * b == a || (a ^ b) >= 0L ? q : q - 1L;
    }

    public static double idiv(double a, double b) {
        return Math.floor(a / b);
    }

    public static double pow(long a, long b) {
        return Math.pow(a, b);
    }

    public static double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public static long unm(long n) {
        return -n;
    }

    public static double unm(double n) {
        return -n;
    }

    public static long band(long a, long b) {
        return a & b;
    }

    public static long bor(long a, long b) {
        return a | b;
    }

    public static long bxor(long a, long b) {
        return a ^ b;
    }

    public static long shl(long a, long b) {
        return b < 0L ? LuaMathOperators.shr(a, -b) : (b < 64L ? a << (int)b : 0L);
    }

    public static long shr(long a, long b) {
        return b < 0L ? LuaMathOperators.shl(a, -b) : (b < 64L ? a >>> (int)b : 0L);
    }

    public static long bnot(long n) {
        return n ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static boolean hasExactIntegerRepresentation(double d) {
        long l = (long)d;
        return (double)l == d && l != Long.MAX_VALUE;
    }

    public static boolean hasExactFloatRepresentation(long l) {
        double d = l;
        return (long)d == l && l != Long.MAX_VALUE;
    }

    public static boolean eq(long a, long b) {
        return a == b;
    }

    public static boolean eq(long a, double b) {
        return LuaMathOperators.hasExactFloatRepresentation(a) && (double)a == b;
    }

    public static boolean eq(double a, long b) {
        return LuaMathOperators.hasExactFloatRepresentation(b) && a == (double)b;
    }

    public static boolean eq(double a, double b) {
        return a == b;
    }

    public static boolean lt(long a, long b) {
        return a < b;
    }

    public static boolean lt(long a, double b) {
        if (LuaMathOperators.hasExactFloatRepresentation(a)) {
            return (double)a < b;
        }
        return !Double.isNaN(b) && b > -9.223372036854776E18 && (b >= 9.223372036854776E18 || a < (long)b);
    }

    public static boolean lt(double a, long b) {
        return !Double.isNaN(a) && !LuaMathOperators.le(b, a);
    }

    public static boolean lt(double a, double b) {
        return a < b;
    }

    public static boolean le(long a, long b) {
        return a <= b;
    }

    public static boolean le(long a, double b) {
        if (LuaMathOperators.hasExactFloatRepresentation(a)) {
            return (double)a <= b;
        }
        return !Double.isNaN(b) && b > -9.223372036854776E18 && (b >= 9.223372036854776E18 || a <= (long)b);
    }

    public static boolean le(double a, long b) {
        return !Double.isNaN(a) && !LuaMathOperators.lt(b, a);
    }

    public static boolean le(double a, double b) {
        return a <= b;
    }
}

