/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.parser.util.Util;

public class Code {
    private final List<BasicBlock> blocks;
    private final Map<Label, BasicBlock> index;

    private Code(List<BasicBlock> blocks) {
        Code.verify(blocks);
        this.blocks = Objects.requireNonNull(blocks);
        this.index = Code.index(blocks);
    }

    public static Code of(List<BasicBlock> blocks) {
        return new Code(new ArrayList<BasicBlock>((Collection)Objects.requireNonNull(blocks)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Code that = (Code)o;
        return this.blocks.equals(that.blocks);
    }

    public int hashCode() {
        return this.blocks.hashCode();
    }

    private static List<BasicBlock> verify(List<BasicBlock> blocks) {
        Objects.requireNonNull(blocks);
        if (blocks.isEmpty()) {
            throw new IllegalArgumentException("Empty block sequence");
        }
        HashSet<Label> defs = new HashSet<Label>();
        HashSet<Label> pending = new HashSet<Label>();
        for (BasicBlock b : blocks) {
            Label l = b.label();
            if (!defs.add(l)) {
                throw new IllegalArgumentException("Label " + l + " defined more than once");
            }
            pending.remove(l);
            for (Label nxt : b.end().nextLabels()) {
                if (defs.contains(nxt)) continue;
                pending.add(nxt);
            }
        }
        if (!pending.isEmpty()) {
            throw new IllegalStateException("Label(s) not defined: " + Util.iterableToString(pending, ", "));
        }
        return blocks;
    }

    private static Map<Label, BasicBlock> index(Iterable<BasicBlock> blocks) {
        HashMap<Label, BasicBlock> result = new HashMap<Label, BasicBlock>();
        for (BasicBlock b : blocks) {
            result.put(b.label(), b);
        }
        return Collections.unmodifiableMap(result);
    }

    public BasicBlock entryBlock() {
        return this.blocks.get(0);
    }

    public Label entryLabel() {
        return this.entryBlock().label();
    }

    public BasicBlock block(Label label) {
        Objects.requireNonNull(label);
        BasicBlock result = this.index.get(label);
        if (result != null) {
            return result;
        }
        throw new NoSuchElementException("Label not found: " + label);
    }

    public Iterable<Label> labels() {
        return this.index.keySet();
    }

    public Iterator<BasicBlock> blockIterator() {
        return this.blocks.iterator();
    }
}

