/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.lang.reflect.Field;
import java.util.Objects;
import org.classdump.luna.LuaRuntimeException;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.Userdata;
import org.classdump.luna.Variable;
import org.classdump.luna.impl.UnimplementedFunction;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.BadArgumentException;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;

public final class DebugLib {
    static final LuaFunction DEBUG = new Debug();
    static final LuaFunction GETHOOK = new GetHook();
    static final LuaFunction GETINFO = new GetInfo();
    static final LuaFunction GETLOCAL = new GetLocal();
    static final LuaFunction GETMETATABLE = new GetMetatable();
    static final LuaFunction GETREGISTRY = new GetRegistry();
    static final LuaFunction GETUPVALUE = new GetUpvalue();
    static final LuaFunction GETUSERVALUE = new GetUserValue();
    static final LuaFunction SETHOOK = new SetHook();
    static final LuaFunction SETLOCAL = new SetLocal();
    static final LuaFunction SETMETATABLE = new SetMetatable();
    static final LuaFunction SETUPVALUE = new SetUpvalue();
    static final LuaFunction SETUSERVALUE = new SetUserValue();
    static final LuaFunction TRACEBACK = new Traceback();
    static final LuaFunction UPVALUEID = new UpvalueId();
    static final LuaFunction UPVALUEJOIN = new UpvalueJoin();

    static LuaFunction debug() {
        return DEBUG;
    }

    static LuaFunction gethook() {
        return GETHOOK;
    }

    static LuaFunction getinfo() {
        return GETINFO;
    }

    static LuaFunction getlocal() {
        return GETLOCAL;
    }

    public static LuaFunction getmetatable() {
        return GETMETATABLE;
    }

    static LuaFunction getregistry() {
        return GETREGISTRY;
    }

    public static LuaFunction getupvalue() {
        return GETUPVALUE;
    }

    public static LuaFunction getuservalue() {
        return GETUSERVALUE;
    }

    static LuaFunction sethook() {
        return SETHOOK;
    }

    static LuaFunction setlocal() {
        return SETLOCAL;
    }

    public static LuaFunction setmetatable() {
        return SETMETATABLE;
    }

    public static LuaFunction setupvalue() {
        return SETUPVALUE;
    }

    public static LuaFunction setuservalue() {
        return SETUSERVALUE;
    }

    static LuaFunction traceback() {
        return TRACEBACK;
    }

    public static LuaFunction upvalueid() {
        return UPVALUEID;
    }

    public static LuaFunction upvaluejoin() {
        return UPVALUEJOIN;
    }

    private DebugLib() {
    }

    public static void installInto(StateContext context, Table env) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        Table t = context.newTable();
        t.rawset("debug", (Object)DebugLib.debug());
        t.rawset("gethook", (Object)DebugLib.gethook());
        t.rawset("getinfo", (Object)DebugLib.getinfo());
        t.rawset("getlocal", (Object)DebugLib.getlocal());
        t.rawset("getmetatable", (Object)DebugLib.getmetatable());
        t.rawset("getregistry", (Object)DebugLib.getregistry());
        t.rawset("getupvalue", (Object)DebugLib.getupvalue());
        t.rawset("getuservalue", (Object)DebugLib.getuservalue());
        t.rawset("sethook", (Object)DebugLib.sethook());
        t.rawset("setlocal", (Object)DebugLib.setlocal());
        t.rawset("setmetatable", (Object)DebugLib.setmetatable());
        t.rawset("setupvalue", (Object)DebugLib.setupvalue());
        t.rawset("setuservalue", (Object)DebugLib.setuservalue());
        t.rawset("traceback", (Object)DebugLib.traceback());
        t.rawset("upvalueid", (Object)DebugLib.upvalueid());
        t.rawset("upvaluejoin", (Object)DebugLib.upvaluejoin());
        ModuleLib.install(env, "debug", t);
    }

    static class Traceback
    extends UnimplementedFunction {
        public Traceback() {
            super("debug.traceback");
        }
    }

    static class SetUserValue
    extends AbstractLibFunction {
        SetUserValue() {
        }

        @Override
        protected String name() {
            return "setuservalue";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Userdata<Object> userdata = args.nextUserdata();
            Object value = args.nextAny();
            userdata.setUserValue(value);
            context.getReturnBuffer().setTo(userdata);
        }
    }

    static class GetUserValue
    extends AbstractLibFunction {
        GetUserValue() {
        }

        @Override
        protected String name() {
            return "getuservalue";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object o = args.hasNext() ? args.peek() : null;
            Object result = o instanceof Userdata ? ((Userdata)o).getUserValue() : null;
            context.getReturnBuffer().setTo(result);
        }
    }

    static class UpvalueJoin
    extends AbstractLibFunction {
        UpvalueJoin() {
        }

        @Override
        protected String name() {
            return "upvaluejoin";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            args.goTo(1);
            int n1 = args.nextInt();
            args.goTo(0);
            LuaFunction f1 = args.nextFunction();
            UpvalueRef uvRef1 = UpvalueRef.find(f1, n1 - 1);
            if (uvRef1 == null) {
                throw new BadArgumentException(2, this.name(), "invalid upvalue index");
            }
            args.goTo(3);
            int n2 = args.nextInt();
            args.goTo(2);
            LuaFunction f2 = args.nextFunction();
            UpvalueRef uvRef2 = UpvalueRef.find(f2, n2 - 1);
            if (uvRef2 == null) {
                throw new BadArgumentException(4, this.name(), "invalid upvalue index");
            }
            try {
                uvRef1.set(uvRef2.get());
            }
            catch (IllegalAccessException ex) {
                throw new LuaRuntimeException(ex);
            }
            context.getReturnBuffer().setTo();
        }
    }

    static class UpvalueId
    extends AbstractLibFunction {
        UpvalueId() {
        }

        @Override
        protected String name() {
            return "upvalueid";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Variable uv;
            args.goTo(1);
            int n = args.nextInt();
            args.goTo(0);
            LuaFunction f = args.nextFunction();
            UpvalueRef uvRef = UpvalueRef.find(f, n - 1);
            if (uvRef == null) {
                throw new BadArgumentException(2, this.name(), "invalid upvalue index");
            }
            try {
                uv = uvRef.get();
            }
            catch (IllegalAccessException ex) {
                throw new LuaRuntimeException(ex);
            }
            context.getReturnBuffer().setTo(uv);
        }
    }

    static class SetUpvalue
    extends AbstractLibFunction {
        SetUpvalue() {
        }

        @Override
        protected String name() {
            return "setupvalue";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            String name;
            args.skip();
            args.skip();
            Object newValue = args.nextAny();
            args.rewind();
            args.skip();
            int index = args.nextInt();
            args.rewind();
            LuaFunction f = args.nextFunction();
            UpvalueRef uvRef = UpvalueRef.find(f, index - 1);
            if (uvRef != null) {
                try {
                    name = uvRef.name();
                    Variable uv = uvRef.get();
                    uv.set(newValue);
                }
                catch (IllegalAccessException ex) {
                    throw new LuaRuntimeException(ex);
                }
            } else {
                name = null;
            }
            context.getReturnBuffer().setTo(name);
        }
    }

    static class GetUpvalue
    extends AbstractLibFunction {
        GetUpvalue() {
        }

        @Override
        protected String name() {
            return "getupvalue";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            args.skip();
            int index = args.nextInt();
            args.rewind();
            LuaFunction f = args.nextFunction();
            UpvalueRef uvRef = UpvalueRef.find(f, index - 1);
            if (uvRef != null) {
                Object value;
                String name;
                try {
                    name = uvRef.name();
                    Variable uv = uvRef.get();
                    value = uv.get();
                }
                catch (IllegalAccessException ex) {
                    throw new LuaRuntimeException(ex);
                }
                context.getReturnBuffer().setTo(name, value);
            } else {
                context.getReturnBuffer().setTo();
            }
        }
    }

    static class SetMetatable
    extends AbstractLibFunction {
        SetMetatable() {
        }

        @Override
        protected String name() {
            return "setmetatable";
        }

        private Table nilOrTable(ArgumentIterator args) {
            if (args.hasNext()) {
                Object o = args.peek();
                if (o instanceof Table) {
                    return (Table)o;
                }
                if (o == null) {
                    return null;
                }
            }
            throw new BadArgumentException(2, this.name(), "nil or table expected");
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object value = args.hasNext() ? args.peek() : null;
            args.skip();
            Table mt = this.nilOrTable(args);
            context.setMetatable(value, mt);
            context.getReturnBuffer().setTo(value);
        }
    }

    static class GetMetatable
    extends AbstractLibFunction {
        GetMetatable() {
        }

        @Override
        protected String name() {
            return "getmetatable";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Object value = args.nextAny();
            Table mt = context.getMetatable(value);
            context.getReturnBuffer().setTo(mt);
        }
    }

    static class GetRegistry
    extends UnimplementedFunction {
        public GetRegistry() {
            super("debug.getregistry");
        }
    }

    static class SetLocal
    extends UnimplementedFunction {
        public SetLocal() {
            super("debug.setlocal");
        }
    }

    static class GetLocal
    extends UnimplementedFunction {
        public GetLocal() {
            super("debug.getlocal");
        }
    }

    static class SetHook
    extends UnimplementedFunction {
        public SetHook() {
            super("debug.sethook");
        }
    }

    static class GetHook
    extends UnimplementedFunction {
        public GetHook() {
            super("debug.gethook");
        }
    }

    static class GetInfo
    extends UnimplementedFunction {
        public GetInfo() {
            super("debug.getinfo");
        }
    }

    static class Debug
    extends UnimplementedFunction {
        public Debug() {
            super("debug.debug");
        }
    }

    static class UpvalueRef {
        private final int index;
        private final LuaFunction function;
        private final Field field;

        public UpvalueRef(int index, LuaFunction function, Field field) {
            this.index = index;
            this.function = Objects.requireNonNull(function);
            this.field = Objects.requireNonNull(field);
        }

        public static UpvalueRef find(LuaFunction f, int index) {
            Objects.requireNonNull(f);
            int idx = 0;
            for (Field fld : f.getClass().getDeclaredFields()) {
                Class<?> fldType = fld.getType();
                if (!Variable.class.isAssignableFrom(fldType)) continue;
                if (idx == index) {
                    fld.setAccessible(true);
                    return new UpvalueRef(index, f, fld);
                }
                ++idx;
            }
            return null;
        }

        public String name() {
            return this.field.getName();
        }

        public int index() {
            return this.index;
        }

        public Variable get() throws IllegalAccessException {
            return (Variable)this.field.get(this.function);
        }

        public void set(Variable ref) throws IllegalAccessException {
            Objects.requireNonNull(ref);
            this.field.set(this.function, ref);
        }
    }
}

