/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.util.Check;

public class StringPattern {
    private final List<PI> items;
    private final int numCaptures;
    private static final String MAGIC_CHARS = "^$()%.[]*+-?";
    private static final String PUNCTUATION_CHARS = ".,;:?!";
    private static final int NO_MATCH = -1;
    private static final PI_begin PI_BEGIN = new PI_begin();
    private static final PI_eos PI_EOS = new PI_eos();

    private StringPattern(List<PI> items, int numCaptures) {
        this.items = Objects.requireNonNull(items);
        this.numCaptures = Check.nonNegative(numCaptures);
    }

    private static boolean isMagic(char c) {
        return MAGIC_CHARS.indexOf(c) != -1;
    }

    public Match match(String s, int fromIndex) {
        while (fromIndex >= 0 && fromIndex <= s.length()) {
            MatchState ms = new MatchState(this.items, s, fromIndex);
            int result = ms.start();
            if (result != -1) {
                return new Match(s, fromIndex, result, Collections.unmodifiableList(Arrays.asList(ms.cap)));
            }
            ++fromIndex;
        }
        return null;
    }

    public static StringPattern fromString(String pattern, boolean ignoreCaret) {
        return new PatternBuilder(pattern, ignoreCaret).parse();
    }

    public static StringPattern fromString(String pattern) {
        return StringPattern.fromString(pattern, false);
    }

    private static String listOfPIToString(List<PI> items) {
        StringBuilder builder = new StringBuilder();
        for (PI pi : items) {
            builder.append(pi.toString());
        }
        return builder.toString();
    }

    public String toString() {
        return StringPattern.listOfPIToString(this.items);
    }

    static class PatternBuilder {
        private final String pattern;
        private final boolean anchoredBegin;
        private int index;
        private int nextCaptureIndex;
        private Set<Integer> assignedCaptures;

        PatternBuilder(String pattern, boolean ignoreCaret) {
            boolean anchoredBegin;
            if (pattern.startsWith("^")) {
                pattern = pattern.substring(1);
                anchoredBegin = !ignoreCaret;
            } else {
                anchoredBegin = false;
            }
            this.pattern = Objects.requireNonNull(pattern);
            this.anchoredBegin = anchoredBegin;
            this.index = 0;
            this.nextCaptureIndex = 1;
            this.assignedCaptures = new HashSet<Integer>();
        }

        private static RuntimeException parseError(int index, String message) {
            return new IllegalArgumentException("error at character " + index + ": " + message);
        }

        private char peek() {
            if (this.index < this.pattern.length()) {
                return this.pattern.charAt(this.index);
            }
            throw PatternBuilder.parseError(this.index, "unexpected <eos>");
        }

        private String pretty(int idx) {
            return idx < this.pattern.length() ? "'" + this.pattern.charAt(idx) + "'" : "<eos>";
        }

        private boolean isEos() {
            return this.index >= this.pattern.length();
        }

        private void consume(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.consume(s.charAt(i));
            }
        }

        private void consume(char c) {
            if (this.index < this.pattern.length() && this.pattern.charAt(this.index) == c) {
                ++this.index;
            } else {
                throw PatternBuilder.parseError(this.index, "expected '" + c + "', got " + this.pretty(this.index));
            }
        }

        private char next() {
            char c = this.peek();
            ++this.index;
            return c;
        }

        private void skip(int offset) {
            this.index += offset;
        }

        private Repeat repeat() {
            if (!this.isEos()) {
                char d = this.peek();
                switch (d) {
                    case '+': {
                        this.skip(1);
                        return Repeat.ONE_OR_MORE;
                    }
                    case '*': {
                        this.skip(1);
                        return Repeat.LONGEST_ZERO_OR_MORE;
                    }
                    case '-': {
                        this.skip(1);
                        return Repeat.SHORTEST_ZERO_OR_MORE;
                    }
                    case '?': {
                        this.skip(1);
                        return Repeat.AT_MOST_ONCE;
                    }
                }
            }
            return Repeat.EXACTLY_ONCE;
        }

        private CharacterSet.SetElement characterSetElement() {
            CC ccl = this.tryEscapedCC();
            if (ccl != null) {
                return new CharacterSet.CharacterClassSetElement(ccl);
            }
            char c = this.next();
            if (this.peek() == '-') {
                this.consume("-");
                char d = this.next();
                return new CharacterSet.RangeSetElement(c, d);
            }
            return new CharacterSet.CharacterClassSetElement(this.CC_lit(c));
        }

        private CharacterSet characterSetBody() {
            ArrayList<CharacterSet.SetElement> elems = new ArrayList<CharacterSet.SetElement>();
            while (!this.isEos() && this.peek() != ']') {
                elems.add(this.characterSetElement());
            }
            if (elems.isEmpty()) {
                throw PatternBuilder.parseError(this.index, "empty character set");
            }
            return new CharacterSet(Collections.unmodifiableList(elems));
        }

        private void PI_frontier(List<PI> pis) {
            this.consume("%f[");
            CharacterSet cs = this.characterSetBody();
            this.consume("]");
            pis.add(new PI_frontier(cs));
        }

        private void PI_balanced(List<PI> pis) {
            this.consume("%b");
            char x = this.next();
            char y = this.next();
            if (x == y) {
                throw PatternBuilder.parseError(this.index, "x == y in %bxy");
            }
            pis.add(new PI_balanced(x, y));
        }

        private void PI_cmatch(List<PI> pis) {
            int cidx;
            this.consume("%");
            char c = this.next();
            if (c >= '1' && c <= '9') {
                cidx = c - 48;
                if (!this.assignedCaptures.contains(cidx)) {
                    throw PatternBuilder.parseError(this.index, "capture #" + cidx + " not resolved at this point");
                }
            } else {
                throw PatternBuilder.parseError(this.index, "expected '1'..'9', got " + this.pretty(this.index));
            }
            pis.add(new PI_cmatch(cidx));
        }

        private int charAtOffset(int idx) {
            int j = this.index + idx;
            return j >= 0 && j < this.pattern.length() ? (int)this.pattern.charAt(j) : -1;
        }

        private boolean continuesWith(String s) {
            for (int i = 0; i < s.length(); ++i) {
                int j = this.index + i;
                if (j < this.pattern.length() && s.charAt(i) == this.pattern.charAt(j)) continue;
                return false;
            }
            return true;
        }

        private CC_lit CC_lit(char c) {
            if (StringPattern.isMagic(c)) {
                throw PatternBuilder.parseError(this.index, "unexpected character '" + c + "'");
            }
            return new CC_lit(c);
        }

        private static CC_spec.ClassDesc maybeClassDesc(int c) {
            switch (c) {
                case 97: {
                    return CC_spec.ClassDesc.LETTERS;
                }
                case 99: {
                    return CC_spec.ClassDesc.CONTROL_CHARS;
                }
                case 100: {
                    return CC_spec.ClassDesc.DECIMAL_DIGITS;
                }
                case 103: {
                    return CC_spec.ClassDesc.PRINTABLE_EXCEPT_SPACE;
                }
                case 108: {
                    return CC_spec.ClassDesc.LOWERCASE_LETTERS;
                }
                case 112: {
                    return CC_spec.ClassDesc.PUNCTUATION;
                }
                case 115: {
                    return CC_spec.ClassDesc.SPACE;
                }
                case 117: {
                    return CC_spec.ClassDesc.UPPERCASE_LETTERS;
                }
                case 119: {
                    return CC_spec.ClassDesc.ALPHANUMERIC;
                }
                case 120: {
                    return CC_spec.ClassDesc.HEXADECIMAL_DIGITS;
                }
            }
            return null;
        }

        private CC tryEscapedCC() {
            if (this.continuesWith("%")) {
                int o = this.charAtOffset(1);
                int lo = Character.toLowerCase(o);
                CC_spec.ClassDesc cd = PatternBuilder.maybeClassDesc(lo);
                if (cd != null) {
                    this.consume("%");
                    this.skip(1);
                    return new CC_spec(cd, lo != o);
                }
                this.consume("%");
                char c = this.next();
                return new CC_lit(c);
            }
            return null;
        }

        private CC cclass() {
            if (this.continuesWith("[^")) {
                this.consume("[^");
                CharacterSet cs = this.characterSetBody();
                this.consume("]");
                return new CC_set(cs, true);
            }
            if (this.continuesWith("[")) {
                this.consume("[");
                CharacterSet cs = this.characterSetBody();
                this.consume("]");
                return new CC_set(cs, false);
            }
            CC ccl = this.tryEscapedCC();
            if (ccl != null) {
                return ccl;
            }
            char c = this.next();
            if (c == '.') {
                return new CC_spec(CC_spec.ClassDesc.ALL, false);
            }
            return this.CC_lit(c);
        }

        private void PI_cc(List<PI> pis) {
            CC ccl = this.cclass();
            Repeat mod = this.repeat();
            pis.add(new PI_cc(ccl, mod));
        }

        private void PI(List<PI> pis) {
            if (this.continuesWith("(")) {
                this.PI_capture(pis);
            } else if (this.continuesWith("%f[")) {
                this.PI_frontier(pis);
            } else if (this.continuesWith("%b")) {
                this.PI_balanced(pis);
            } else if (this.continuesWith("%") && this.charAtOffset(1) >= 49 && this.charAtOffset(1) <= 57) {
                this.PI_cmatch(pis);
            } else if (this.continuesWith("$") && this.charAtOffset(1) == -1) {
                this.skip(1);
                pis.add(PI_EOS);
            } else {
                this.PI_cc(pis);
            }
        }

        private void PI_capture(List<PI> pis) {
            int capIdx = this.nextCaptureIndex++;
            this.consume('(');
            ArrayList<PI> nested = new ArrayList<PI>();
            while (!this.isEos() && this.peek() != ')') {
                this.PI(nested);
            }
            this.consume(')');
            this.assignedCaptures.add(capIdx);
            if (nested.isEmpty()) {
                pis.add(new PI_capture_pos(capIdx));
            } else {
                pis.add(new PI_capture_begin(capIdx));
                pis.addAll(nested);
                pis.add(new PI_capture_end(capIdx));
            }
        }

        private StringPattern parse() {
            List<PI> items = new ArrayList<PI>();
            if (this.anchoredBegin) {
                items.add(PI_BEGIN);
            }
            while (!this.isEos()) {
                this.PI(items);
            }
            items = Collections.unmodifiableList(items);
            return new StringPattern(items, this.nextCaptureIndex - 1);
        }
    }

    static class PI_capture_end
    extends PI_capture {
        PI_capture_end(int index) {
            super(index);
        }

        public String toString() {
            return ")";
        }

        @Override
        public int match(MatchState ms) {
            int endIdx = Math.min(ms.str.length(), ms.strIdx);
            String s = ms.str.substring(ms.capBegin[this.index - 1], endIdx);
            ((MatchState)ms).cap[this.index - 1] = s;
            return ms.next(ms.strIdx);
        }
    }

    static class PI_capture_begin
    extends PI_capture {
        PI_capture_begin(int index) {
            super(index);
        }

        public String toString() {
            return "(";
        }

        @Override
        public int match(MatchState ms) {
            ((MatchState)ms).capBegin[this.index - 1] = ms.strIdx;
            return ms.next(ms.strIdx);
        }
    }

    static class PI_capture_pos
    extends PI_capture {
        PI_capture_pos(int index) {
            super(index);
        }

        public String toString() {
            return "()";
        }

        @Override
        public int match(MatchState ms) {
            ((MatchState)ms).cap[this.index - 1] = (long)(ms.strIdx + 1);
            return ms.next(ms.strIdx);
        }
    }

    static abstract class PI_capture
    extends PI {
        protected final int index;

        PI_capture(int index) {
            this.index = Check.positive(index);
        }
    }

    static class PI_frontier
    extends PI {
        private final CharacterSet cs;

        PI_frontier(CharacterSet cs) {
            this.cs = Objects.requireNonNull(cs);
        }

        public String toString() {
            return "%f[" + this.cs.toString() + "]";
        }

        @Override
        public int match(MatchState ms) {
            if (ms.strIdx > 0 && ms.strIdx < ms.str.length()) {
                char c = ms.str.charAt(ms.strIdx - 1);
                char d = ms.str.charAt(ms.strIdx);
                if (!this.cs.matches(c) && this.cs.matches(d)) {
                    return ms.next(ms.strIdx);
                }
                return -1;
            }
            return -1;
        }
    }

    static class PI_balanced
    extends PI {
        private final char first;
        private final char second;

        PI_balanced(char first, char second) {
            Check.isTrue(first != second);
            this.first = first;
            this.second = second;
        }

        public String toString() {
            return "%b" + this.first + this.second;
        }

        @Override
        public int match(MatchState ms) {
            int idx = ms.strIdx;
            if (idx >= ms.str.length() || ms.str.charAt(idx) != this.first) {
                return -1;
            }
            int balance = 0;
            while (idx < ms.str.length()) {
                int nxt;
                char c = ms.str.charAt(idx);
                if (c == this.first) {
                    ++balance;
                } else if (c == this.second) {
                    --balance;
                }
                if (balance != 0 || (nxt = ms.next(++idx)) == -1) continue;
                return nxt;
            }
            return -1;
        }
    }

    static class PI_cmatch
    extends PI {
        private final int index;

        PI_cmatch(int index) {
            this.index = Check.inRange(index, 1, 9);
        }

        public String toString() {
            return "%" + this.index;
        }

        @Override
        public int match(MatchState ms) {
            Object o = ms.cap[this.index - 1];
            if (o instanceof String) {
                String cs = (String)o;
                int offset = ms.strIdx;
                for (int i = 0; i < cs.length(); ++i) {
                    if (offset + i >= ms.str.length()) {
                        return -1;
                    }
                    if (ms.str.charAt(offset + i) == cs.charAt(i)) continue;
                    return -1;
                }
                return ms.next(offset + cs.length());
            }
            return -1;
        }
    }

    static class PI_cc
    extends PI {
        private final CC ccl;
        private final Repeat mod;

        PI_cc(CC ccl, Repeat mod) {
            this.ccl = Objects.requireNonNull(ccl);
            this.mod = Objects.requireNonNull(mod);
        }

        public String toString() {
            return this.ccl.toString() + this.mod.toString();
        }

        @Override
        public int match(MatchState ms) {
            switch (this.mod) {
                case EXACTLY_ONCE: {
                    int c = ms.peek();
                    if (this.ccl.matches(c)) {
                        return ms.next(ms.strIdx + 1);
                    }
                    return -1;
                }
                case LONGEST_ZERO_OR_MORE: {
                    int max;
                    int min;
                    int i = min = ms.strIdx;
                    while (this.ccl.matches(ms.peek(i))) {
                        ++i;
                    }
                    for (int j = max = i; j >= min; --j) {
                        int nxt = ms.next(j);
                        if (nxt == -1) continue;
                        return nxt;
                    }
                    return -1;
                }
                case SHORTEST_ZERO_OR_MORE: {
                    int min;
                    int i = min = ms.strIdx;
                    while (this.ccl.matches(ms.peek(i))) {
                        ++i;
                    }
                    int max = i;
                    for (int j = min; j < max; ++j) {
                        int nxt = ms.next(j);
                        if (nxt == -1) continue;
                        return nxt;
                    }
                    return -1;
                }
                case ONE_OR_MORE: {
                    int c = ms.peek();
                    if (this.ccl.matches(c)) {
                        int max;
                        int min;
                        int i = min = ms.strIdx + 1;
                        while (this.ccl.matches(ms.peek(i))) {
                            ++i;
                        }
                        for (int j = max = i; j >= min; --j) {
                            int nxt = ms.next(j);
                            if (nxt == -1) continue;
                            return nxt;
                        }
                        return -1;
                    }
                    return -1;
                }
                case AT_MOST_ONCE: {
                    int nxt;
                    int c = ms.peek();
                    if (this.ccl.matches(c) && (nxt = ms.next(ms.strIdx + 1)) != -1) {
                        return nxt;
                    }
                    return ms.next(ms.strIdx);
                }
            }
            throw new IllegalStateException();
        }
    }

    static class PI_eos
    extends PI {
        PI_eos() {
        }

        public String toString() {
            return "$";
        }

        @Override
        public int match(MatchState ms) {
            if (ms.strIdx == ms.str.length() - 1) {
                return ms.next(ms.strIdx);
            }
            return -1;
        }
    }

    static class PI_begin
    extends PI {
        PI_begin() {
        }

        public String toString() {
            return "^";
        }

        @Override
        public int match(MatchState ms) {
            if (ms.strIdx == 0) {
                return ms.next(ms.strIdx);
            }
            return -1;
        }
    }

    static abstract class PI {
        PI() {
        }

        public abstract int match(MatchState var1);
    }

    class MatchState {
        private final int piIdx;
        private final List<PI> pis;
        private final String str;
        private final int strIdx;
        private final int[] capBegin;
        private final Object[] cap;

        MatchState(int piIdx, List<PI> pis, String str, int strIdx, int[] capBegin, Object[] cap) {
            this.piIdx = piIdx;
            this.pis = pis;
            this.str = str;
            this.strIdx = strIdx;
            this.capBegin = capBegin;
            this.cap = cap;
        }

        MatchState(List<PI> pis, String str, int strIdx) {
            this(0, pis, str, strIdx, new int[this$0.numCaptures], new Object[this$0.numCaptures]);
        }

        private PI pi() {
            return this.pis.get(this.piIdx);
        }

        private MatchState nextState(int strIdx) {
            if (this.piIdx + 1 < this.pis.size()) {
                return new MatchState(this.piIdx + 1, this.pis, this.str, strIdx, this.capBegin, this.cap);
            }
            return null;
        }

        public int start() {
            if (this.pis.isEmpty()) {
                return this.strIdx;
            }
            PI pi = this.pis.get(0);
            return pi.match(this);
        }

        public int next(int strIdx) {
            MatchState ms = this.nextState(strIdx);
            if (ms != null) {
                return ms.pi().match(ms);
            }
            return strIdx;
        }

        public int peek(int pos) {
            return pos >= 0 && pos < this.str.length() ? (int)this.str.charAt(pos) : -1;
        }

        public int peek() {
            return this.peek(this.strIdx);
        }
    }

    static enum Repeat {
        EXACTLY_ONCE(""),
        LONGEST_ZERO_OR_MORE("*"),
        SHORTEST_ZERO_OR_MORE("-"),
        ONE_OR_MORE("+"),
        AT_MOST_ONCE("?");

        private final String s;

        private Repeat(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }

    static class CC_set
    extends CC {
        private final CharacterSet cs;
        private final boolean complement;

        CC_set(CharacterSet cs, boolean complement) {
            this.cs = Objects.requireNonNull(cs);
            this.complement = complement;
        }

        public String toString() {
            return (this.complement ? "[^" : "[") + this.cs.toString() + "]";
        }

        @Override
        public boolean matches(int c) {
            return c >= 0 && this.complement != this.cs.matches((char)c);
        }
    }

    static class CC_spec
    extends CC {
        private final ClassDesc desc;
        private final boolean complement;

        CC_spec(ClassDesc desc, boolean complement) {
            Check.isFalse(desc == ClassDesc.ALL && complement);
            this.desc = Objects.requireNonNull(desc);
            this.complement = complement;
        }

        public String toString() {
            String s = this.desc.toString();
            return this.complement ? s.toUpperCase() : s;
        }

        @Override
        public boolean matches(int c) {
            if (c >= 0) {
                if (this.desc == ClassDesc.ALL) {
                    return true;
                }
                char ch = (char)c;
                switch (this.desc) {
                    case LETTERS: {
                        return this.complement != Character.isLetter(ch);
                    }
                    case LOWERCASE_LETTERS: {
                        return this.complement != (Character.isLetter(ch) && Character.isLowerCase(ch));
                    }
                    case UPPERCASE_LETTERS: {
                        return this.complement != (Character.isLetter(ch) && Character.isUpperCase(ch));
                    }
                    case DECIMAL_DIGITS: {
                        return this.complement != (ch >= '0' && ch <= '9');
                    }
                    case HEXADECIMAL_DIGITS: {
                        return this.complement != (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F');
                    }
                    case ALPHANUMERIC: {
                        char lc = Character.toLowerCase(ch);
                        return this.complement != (lc >= '0' && lc <= '9' || lc >= 'a' && lc <= 'z');
                    }
                    case SPACE: {
                        return this.complement != Character.isWhitespace(ch);
                    }
                    case CONTROL_CHARS: {
                        return this.complement != Character.isISOControl(ch);
                    }
                    case PUNCTUATION: {
                        return this.complement != (StringPattern.PUNCTUATION_CHARS.indexOf(ch) != -1);
                    }
                    case PRINTABLE_EXCEPT_SPACE: {
                        return this.complement != (!Character.isISOControl(ch) && ch != ' ');
                    }
                }
                throw new IllegalStateException();
            }
            return false;
        }

        static enum ClassDesc {
            ALL("."),
            LETTERS("%a"),
            LOWERCASE_LETTERS("%l"),
            UPPERCASE_LETTERS("%u"),
            DECIMAL_DIGITS("%d"),
            HEXADECIMAL_DIGITS("%x"),
            ALPHANUMERIC("%w"),
            SPACE("%s"),
            CONTROL_CHARS("%c"),
            PUNCTUATION("%p"),
            PRINTABLE_EXCEPT_SPACE("%g");

            private final String s;

            private ClassDesc(String s) {
                this.s = s;
            }

            public String toString() {
                return this.s;
            }
        }
    }

    static class CC_lit
    extends CC {
        private final char ch;

        CC_lit(char ch) {
            this.ch = ch;
        }

        public String toString() {
            return (StringPattern.isMagic(this.ch) ? "%" : "") + Character.toString(this.ch);
        }

        @Override
        public boolean matches(int c) {
            return c >= 0 && this.ch == (char)c;
        }
    }

    static abstract class CC {
        CC() {
        }

        public abstract boolean matches(int var1);
    }

    static class CharacterSet {
        private final List<SetElement> elements;

        CharacterSet(List<SetElement> elements) {
            this.elements = Objects.requireNonNull(elements);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            for (SetElement element : this.elements) {
                bld.append(element);
            }
            return bld.toString();
        }

        public boolean matches(char c) {
            for (SetElement elem : this.elements) {
                if (!elem.matches(c)) continue;
                return true;
            }
            return false;
        }

        static class CharacterClassSetElement
        extends SetElement {
            private final CC ccl;

            CharacterClassSetElement(CC ccl) {
                this.ccl = Objects.requireNonNull(ccl);
            }

            public String toString() {
                return this.ccl.toString();
            }

            @Override
            public boolean matches(char c) {
                return this.ccl.matches(c);
            }
        }

        static class RangeSetElement
        extends SetElement {
            private final char min;
            private final char max;

            RangeSetElement(char min, char max) {
                this.min = min;
                this.max = max;
            }

            public String toString() {
                return this.min + "-" + this.max;
            }

            @Override
            public boolean matches(char c) {
                return c >= this.min && c <= this.max;
            }
        }

        static abstract class SetElement {
            SetElement() {
            }

            public abstract boolean matches(char var1);
        }
    }

    public static class Match {
        private final String originalString;
        private final int beginIndex;
        private final int endIndex;
        private final List<Object> captures;

        protected Match(String originalString, int beginIndex, int endIndex, List<Object> captures) {
            this.originalString = Objects.requireNonNull(originalString);
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.captures = Objects.requireNonNull(captures);
        }

        public String originalString() {
            return this.originalString;
        }

        public int beginIndex() {
            return this.beginIndex;
        }

        public int endIndex() {
            return this.endIndex;
        }

        public String fullMatch() {
            return this.originalString.substring(this.beginIndex, this.endIndex);
        }

        public List<Object> captures() {
            return this.captures;
        }
    }
}

