/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.util.ArrayList;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.ByteStringBuilder;
import org.classdump.luna.Conversions;
import org.classdump.luna.LuaRuntimeException;
import org.classdump.luna.Ordering;
import org.classdump.luna.PlainValueTypeNamer;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.lib.AbstractLibFunction;
import org.classdump.luna.lib.ArgumentIterator;
import org.classdump.luna.lib.BadArgumentException;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.lib.TableUtil;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.LuaFunction;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.ReturnBuffer;
import org.classdump.luna.runtime.UnresolvedControlThrowable;

public final class TableLib {
    static final LuaFunction CONCAT = new Concat();
    static final LuaFunction INSERT = new Insert();
    static final LuaFunction MOVE = new Move();
    static final LuaFunction PACK = new Pack();
    static final LuaFunction REMOVE = new Remove();
    static final LuaFunction SORT = new Sort();
    static final LuaFunction UNPACK = new Unpack();

    public static LuaFunction concat() {
        return CONCAT;
    }

    public static LuaFunction insert() {
        return INSERT;
    }

    public static LuaFunction move() {
        return MOVE;
    }

    public static LuaFunction pack() {
        return PACK;
    }

    public static LuaFunction remove() {
        return REMOVE;
    }

    public static LuaFunction sort() {
        return SORT;
    }

    public static LuaFunction unpack() {
        return UNPACK;
    }

    private TableLib() {
    }

    public static void installInto(StateContext context, Table env) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(env);
        Table t = context.newTable();
        t.rawset("concat", (Object)TableLib.concat());
        t.rawset("insert", (Object)TableLib.insert());
        t.rawset("move", (Object)TableLib.move());
        t.rawset("pack", (Object)TableLib.pack());
        t.rawset("remove", (Object)TableLib.remove());
        t.rawset("sort", (Object)TableLib.sort());
        t.rawset("unpack", (Object)TableLib.unpack());
        ModuleLib.install(env, "table", t);
    }

    static long getLength(ReturnBuffer rbuf) {
        Object o = rbuf.get0();
        Long l = Conversions.integerValueOf(o);
        if (l != null) {
            return l;
        }
        throw new LuaRuntimeException((Object)"object length is not an integer");
    }

    static class Unpack
    extends AbstractLibFunction {
        public static final long MAX_RESULTS = 1000000L;
        private static final int STATE_LEN_PREPARE = 0;
        private static final int STATE_LEN_RESUME = 1;
        private static final int STATE_BEFORE_LOOP = 2;
        private static final int STATE_LOOP = 3;

        Unpack() {
        }

        @Override
        protected String name() {
            return "unpack";
        }

        private static void verifyNumberOfResults(long i, long j) {
            long n;
            if (i < j && ((n = j - i) < 0L || n > 1000000L)) {
                throw new IllegalArgumentException("too many results to unpack");
            }
        }

        private static void unpackUsingRawGet(ExecutionContext context, Table t, long i, long j) {
            ArrayList<Object> r = new ArrayList<Object>();
            for (long k = i; i <= k && k <= j; ++k) {
                r.add(t.rawget(k));
            }
            context.getReturnBuffer().setToContentsOf(r);
        }

        private void run(ExecutionContext context, int state, Object obj, long i, long j, long k, ArrayList<Object> result) throws ResolvedControlThrowable {
            try {
                switch (state) {
                    case 0: {
                        state = 1;
                        Dispatch.len(context, obj);
                    }
                    case 1: {
                        j = TableLib.getLength(context.getReturnBuffer());
                    }
                    case 2: {
                        Unpack.verifyNumberOfResults(i, j);
                        if (obj instanceof Table && !TableUtil.hasIndexMetamethod((Table)obj)) {
                            Unpack.unpackUsingRawGet(context, (Table)obj, i, j);
                            return;
                        }
                        if (i <= j) {
                            k = i;
                            state = 3;
                            result = new ArrayList();
                            Dispatch.index(context, obj, (Object)k++);
                        } else {
                            context.getReturnBuffer().setTo();
                            return;
                        }
                    }
                    case 3: {
                        while (true) {
                            Object v = context.getReturnBuffer().get0();
                            result.add(v);
                            if (i > k || k > j) break;
                            state = 3;
                            Dispatch.index(context, obj, (Object)k++);
                        }
                        assert (k > j || k == Long.MIN_VALUE);
                        context.getReturnBuffer().setToContentsOf(result);
                        return;
                    }
                }
                throw new IllegalStateException("Illegal state: " + state);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, obj, i, j, k, result));
            }
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            int state;
            long j;
            Object obj = args.hasNext() ? args.peek() : null;
            args.skip();
            long i = args.nextOptionalInteger(1L);
            if (args.hasNext() && args.peek() != null) {
                j = args.nextInteger();
                state = 2;
            } else if (obj instanceof Table && !TableUtil.hasLenMetamethod((Table)obj)) {
                j = ((Table)obj).rawlen();
                state = 2;
            } else {
                j = 0L;
                state = 0;
            }
            this.run(context, state, obj, i, j, 0L, null);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SuspendedState ss = (SuspendedState)suspendedState;
            this.run(context, ss.state, ss.obj, ss.i, ss.j, ss.k, ss.result);
        }

        private static class SuspendedState {
            public final int state;
            public final Object obj;
            public final long i;
            public final long j;
            public final long k;
            public final ArrayList<Object> result;

            public SuspendedState(int state, Object obj, long i, long j, long k, ArrayList<Object> result) {
                this.state = state;
                this.obj = obj;
                this.i = i;
                this.j = j;
                this.k = k;
                this.result = result;
            }
        }
    }

    static class Sort
    extends AbstractLibFunction {
        private static final int STATE_OFFSET_LEN = 0;
        private static final int STATE_OFFSET_HEAPIFY = 2;
        private static final int STATE_OFFSET_SORT = 4;

        Sort() {
        }

        @Override
        protected String name() {
            return "sort";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Table t = args.nextTable();
            if (!TableUtil.hasLenMetamethod(t)) {
                long len = t.rawlen();
                this.prepareLoop(context, args, t, len);
            } else {
                this.fetchLen(context, 0, args, t);
            }
        }

        private void fetchLen(ExecutionContext context, int state, ArgumentIterator args, Table t) throws ResolvedControlThrowable {
            long len = 0L;
            try {
                switch (state) {
                    case 0: {
                        state = 1;
                        Dispatch.len(context, t);
                    }
                    case 1: {
                        len = TableLib.getLength(context.getReturnBuffer());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal state: " + state);
                    }
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, -1, args, t, null, 1L, -1L, -1L, null, null, null));
            }
            this.prepareLoop(context, args, t, len);
        }

        private void prepareLoop(ExecutionContext context, ArgumentIterator args, Table t, long len) throws ResolvedControlThrowable {
            Ordering<Object> rawOrdering;
            if (len >= Integer.MAX_VALUE) {
                throw new BadArgumentException(1, this.name(), "array too big");
            }
            if (len < 2L) {
                return;
            }
            LuaFunction comp = args.nextOptionalFunction(null);
            Ordering<Object> ordering = rawOrdering = comp == null && !TableUtil.hasIndexMetamethod(t) && !TableUtil.hasNewIndexMetamethod(t) ? TableUtil.rawSequenceOrderingOf(t, 1L, len) : null;
            if (rawOrdering != null) {
                Sort.rawSort(t, rawOrdering, len);
            } else {
                this.go(context, t, comp, len);
            }
        }

        private static void rawSort(Table t, Ordering<Object> ordering, long len) {
            assert (len > 1L);
            Sort.rawHeapify(t, ordering, len);
            long end = len;
            while (end > 1L) {
                Object beginValue = t.rawget(1L);
                Object endValue = t.rawget(end);
                t.rawset(end, beginValue);
                t.rawset(1L, endValue);
                Sort.rawSiftDown(t, ordering, 1L, --end);
            }
        }

        private static void rawHeapify(Table t, Ordering<Object> ordering, long count) {
            for (long start = count / 2L; start >= 1L; --start) {
                Sort.rawSiftDown(t, ordering, start, count);
            }
        }

        private void go(ExecutionContext context, Table t, LuaFunction comp, long len) throws ResolvedControlThrowable {
            this.heapify(context, 2, t, comp, len / 2L, len);
            this.sort(context, 4, t, comp, len, null, null);
        }

        private void heapify(ExecutionContext context, int state, Table t, LuaFunction comp, long start, long count) throws ResolvedControlThrowable {
            block4: while (true) {
                switch (state) {
                    case 2: {
                        if (start < 1L) break block4;
                        state = 3;
                        this.doSiftDown(context, state, t, comp, start, count);
                    }
                    case 3: {
                        state = 2;
                        --start;
                        continue block4;
                    }
                    default: {
                        throw new IllegalStateException("Illegal state: " + state);
                    }
                }
                break;
            }
        }

        private void sort(ExecutionContext context, int state, Table t, LuaFunction comp, long end, Object beginValue, Object endValue) throws ResolvedControlThrowable {
            try {
                block10: while (true) {
                    switch (state) {
                        case 4: {
                            if (end <= 1L) {
                                context.getReturnBuffer().setTo();
                                return;
                            }
                            state = 5;
                            Dispatch.index(context, t, 1L);
                        }
                        case 5: {
                            beginValue = context.getReturnBuffer().get0();
                            state = 6;
                            Dispatch.index(context, t, end);
                        }
                        case 6: {
                            endValue = context.getReturnBuffer().get0();
                            state = 7;
                            this._lt(context, comp, beginValue, endValue);
                        }
                        case 7: {
                            if (Conversions.booleanValueOf(context.getReturnBuffer().get0())) {
                                throw new IllegalStateException("invalid order function for sorting");
                            }
                            state = 8;
                            Dispatch.setindex(context, t, end, beginValue);
                        }
                        case 8: {
                            state = 9;
                            Dispatch.setindex(context, t, 1L, endValue);
                        }
                        case 9: {
                            state = 4;
                            this.doSiftDown(context, state, t, comp, 1L, --end);
                            continue block10;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Illegal state: " + state);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, -1, null, t, comp, -1L, end, -1L, beginValue, endValue, null));
            }
        }

        private void _lt(ExecutionContext context, LuaFunction comp, Object a, Object b) throws UnresolvedControlThrowable {
            if (comp != null) {
                Dispatch.call(context, comp, a, b);
            } else {
                Dispatch.lt(context, a, b);
            }
        }

        private void doSiftDown(ExecutionContext context, int state, Table t, LuaFunction comp, long start, long end) throws ResolvedControlThrowable {
            this.siftDown(context, state, 0, t, comp, start, end, 0L, null, null, null);
        }

        private void siftDown(ExecutionContext context, int state, int siftState, Table t, LuaFunction comp, long root, long end, long child, Object rootValue, Object childValue, Object tmp) throws ResolvedControlThrowable {
            try {
                block13: while (true) {
                    switch (siftState) {
                        case 0: {
                            if (root * 2L > end) {
                                context.getReturnBuffer().setTo();
                                return;
                            }
                            child = root * 2L;
                            siftState = 1;
                            Dispatch.index(context, t, root);
                        }
                        case 1: {
                            rootValue = context.getReturnBuffer().get0();
                            siftState = 2;
                            Dispatch.index(context, t, child);
                        }
                        case 2: {
                            childValue = context.getReturnBuffer().get0();
                            if (child + 1L > end) {
                                siftState = 5;
                                continue block13;
                            }
                            siftState = 3;
                            Dispatch.index(context, t, child + 1L);
                        }
                        case 3: {
                            tmp = context.getReturnBuffer().get0();
                            siftState = 4;
                            this._lt(context, comp, childValue, tmp);
                        }
                        case 4: {
                            if (Conversions.booleanValueOf(context.getReturnBuffer().get0())) {
                                ++child;
                                childValue = tmp;
                                tmp = null;
                            }
                        }
                        case 5: {
                            siftState = 6;
                            this._lt(context, comp, rootValue, childValue);
                        }
                        case 6: {
                            if (!Conversions.booleanValueOf(context.getReturnBuffer().get0())) {
                                return;
                            }
                            siftState = 7;
                            Dispatch.setindex(context, t, root, childValue);
                        }
                        case 7: {
                            siftState = 8;
                            Dispatch.setindex(context, t, child, rootValue);
                        }
                        case 8: {
                            root = child;
                            siftState = 0;
                            continue block13;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Illegal state: " + state);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, siftState, null, t, comp, root, end, child, rootValue, childValue, tmp));
            }
        }

        private static void swap(Table t, long a, long b, Object va, Object vb) {
            t.rawset(a, vb);
            t.rawset(b, va);
        }

        private static void rawSiftDown(Table t, Ordering<Object> ordering, long start, long end) {
            long root = start;
            while (root * 2L <= end) {
                Object tmp;
                long child = root * 2L;
                Object rootValue = t.rawget(root);
                Object childValue = t.rawget(child);
                if (child + 1L <= end && ordering.lt(childValue, tmp = t.rawget(child + 1L))) {
                    ++child;
                    childValue = tmp;
                }
                if (ordering.lt(rootValue, childValue)) {
                    Sort.swap(t, root, child, rootValue, childValue);
                    root = child;
                    continue;
                }
                return;
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SuspendedState ss = (SuspendedState)suspendedState;
            if (ss.state < 2) {
                this.fetchLen(context, ss.state, ss.args, ss.t);
            } else {
                if (ss.siftState >= 0) {
                    this.siftDown(context, ss.state, ss.siftState, ss.t, ss.comp, ss.i, ss.len, ss.j, ss.o1, ss.o2, ss.o3);
                }
                if (ss.state < 4) {
                    this.heapify(context, ss.state, ss.t, ss.comp, ss.i, ss.len);
                    this.sort(context, 4, ss.t, ss.comp, ss.len, null, null);
                } else {
                    this.sort(context, ss.state, ss.t, ss.comp, ss.len, ss.o1, ss.o2);
                }
            }
        }

        private static class SuspendedState {
            public final int state;
            public final int siftState;
            public final ArgumentIterator args;
            public final Table t;
            public final LuaFunction comp;
            public final long i;
            public final long len;
            public final long j;
            public final Object o1;
            public final Object o2;
            public final Object o3;

            private SuspendedState(int state, int siftState, ArgumentIterator args, Table t, LuaFunction comp, long i, long len, long j, Object o1, Object o2, Object o3) {
                this.state = state;
                this.siftState = siftState;
                this.t = t;
                this.args = args;
                this.comp = comp;
                this.i = i;
                this.len = len;
                this.j = j;
                this.o1 = o1;
                this.o2 = o2;
                this.o3 = o3;
            }
        }
    }

    static class Remove
    extends AbstractLibFunction {
        private static final int PHASE_SHIFT = 4;
        private static final int _LEN = 0;
        private static final int _GET = 1;
        private static final int _LOOP = 2;
        private static final int _ERASE = 4;
        private static final int _LEN_PREPARE = 0;
        private static final int _LEN_RESUME = 1;
        private static final int _GET_PREPARE = 16;
        private static final int _GET_RESUME = 17;
        private static final int _LOOP_TEST = 32;
        private static final int _LOOP_TABGET = 33;
        private static final int _LOOP_TABSET = 34;
        private static final int _ERASE_PREPARE = 64;
        private static final int _ERASE_RESUME = 65;

        Remove() {
        }

        @Override
        protected String name() {
            return "remove";
        }

        private void checkValidPos(long pos, long len) {
            if (!(len == 0L && pos == 0L || pos == len || pos >= 1L && pos <= len + 1L)) {
                throw new BadArgumentException(2, this.name(), "position out of bounds");
            }
        }

        private static Object rawRemove(Table t, long pos, long len) {
            Object result = t.rawget(pos);
            if (pos == 0L || pos == len || pos == len + 1L) {
                t.rawset(pos, (Object)null);
            } else {
                for (long k = pos + 1L; k <= len; ++k) {
                    t.rawset(k - 1L, t.rawget(k));
                }
                t.rawset(len, (Object)null);
            }
            return result;
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Table t = args.nextTable();
            if (!TableUtil.hasLenMetamethod(t)) {
                this.run_args(context, t, args, t.rawlen());
            } else {
                this._len(context, 0, t, args);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SuspendedState ss = (SuspendedState)suspendedState;
            switch (ss.state >> 4) {
                case 0: {
                    this._len(context, ss.state, ss.t, ss.args);
                    break;
                }
                case 1: {
                    this._get_result(context, ss.state, ss.t, ss.pos, ss.len);
                    break;
                }
                case 2: {
                    this._loop(context, ss.state, ss.t, ss.pos, ss.len, ss.result);
                    break;
                }
                case 4: {
                    this._erase(context, ss.state, ss.t, 0L, ss.result);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal state: " + ss.state);
                }
            }
        }

        private void _len(ExecutionContext context, int state, Table t, ArgumentIterator args) throws ResolvedControlThrowable {
            long len;
            try {
                switch (state) {
                    case 0: {
                        state = 1;
                        Dispatch.len(context, t);
                    }
                    case 1: {
                        len = TableLib.getLength(context.getReturnBuffer());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal state: " + state);
                    }
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, t, args, 0L, 0L, null));
            }
            this.run_args(context, t, args, len);
        }

        private void run_args(ExecutionContext context, Table t, ArgumentIterator args, long len) throws ResolvedControlThrowable {
            long pos;
            if (args.hasNext() && args.peek() != null) {
                pos = args.nextInteger();
                this.checkValidPos(pos, len);
            } else {
                pos = len;
            }
            this.start_loop(context, t, pos, len);
        }

        private void start_loop(ExecutionContext context, Table t, long pos, long len) throws ResolvedControlThrowable {
            if (!TableUtil.hasIndexMetamethod(t) && !TableUtil.hasNewIndexMetamethod(t)) {
                Object result = Remove.rawRemove(t, pos, len);
                context.getReturnBuffer().setTo(result);
            } else {
                this._get_result(context, 16, t, pos, len);
            }
        }

        private void _get_result(ExecutionContext context, int state, Table t, long pos, long len) throws ResolvedControlThrowable {
            Object result;
            try {
                switch (state) {
                    case 16: {
                        state = 17;
                        Dispatch.index(context, t, pos);
                    }
                    case 17: {
                        result = context.getReturnBuffer().get0();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal state: " + state);
                    }
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, t, null, pos, len, null));
            }
            if (pos == 0L || pos == len || pos == len + 1L) {
                this._erase(context, 64, t, pos, result);
            } else {
                this._loop(context, 32, t, pos, len, result);
            }
        }

        private void _loop(ExecutionContext context, int state, Table t, long k, long len, Object result) throws ResolvedControlThrowable {
            try {
                block7: while (true) {
                    switch (state) {
                        case 32: {
                            state = 33;
                            if (++k > len) break block7;
                        }
                        case 33: {
                            state = 34;
                            Dispatch.index(context, t, k);
                        }
                        case 34: {
                            state = 32;
                            Object v = context.getReturnBuffer().get0();
                            Dispatch.setindex(context, t, k - 1L, v);
                            continue block7;
                        }
                        default: {
                            throw new IllegalStateException("Illegal state: " + state);
                        }
                    }
                    break;
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, t, null, k, len, result));
            }
            this._erase(context, 64, t, len, result);
        }

        private void _erase(ExecutionContext context, int state, Table t, long idx, Object result) throws ResolvedControlThrowable {
            try {
                switch (state) {
                    case 64: {
                        state = 65;
                        Dispatch.setindex(context, t, idx, null);
                    }
                    case 65: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal state: " + state);
                    }
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, null, null, 0L, 0L, result));
            }
            context.getReturnBuffer().setTo(result);
        }

        private static class SuspendedState {
            public final int state;
            public final Table t;
            public final ArgumentIterator args;
            public final long pos;
            public final long len;
            public final Object result;

            private SuspendedState(int state, Table t, ArgumentIterator args, long pos, long len, Object result) {
                this.state = state;
                this.t = t;
                this.args = args;
                this.pos = pos;
                this.len = len;
                this.result = result;
            }
        }
    }

    static class Pack
    extends AbstractLibFunction {
        Pack() {
        }

        @Override
        protected String name() {
            return "pack";
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Table table = context.newTable();
            int n = 0;
            while (args.hasNext()) {
                table.rawset(n + 1, args.nextAny());
                ++n;
            }
            table.rawset("n", (Object)n);
            context.getReturnBuffer().setTo(table);
        }
    }

    static class Move
    extends AbstractLibFunction {
        Move() {
        }

        @Override
        protected String name() {
            return "move";
        }

        private void checkValidArgs(long f, long e, long t) {
            if (f <= e) {
                long num = e - f + 1L;
                if (num < 1L) {
                    throw new BadArgumentException(3, this.name(), "too many elements to move");
                }
                if (t + (num - 1L) < t) {
                    throw new BadArgumentException(4, this.name(), "destination wrap around");
                }
            }
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            if (args.size() < 2) {
                throw new BadArgumentException(2, this.name(), "number expected, got no value");
            }
            args.goTo(1);
            long f = args.nextInteger();
            long e = args.nextInteger();
            long t = args.nextInteger();
            Table dest = args.nextOptionalTable(null);
            args.goTo(0);
            Table a1 = args.nextTable();
            Table a2 = dest != null ? dest : a1;
            this.checkValidArgs(f, e, t);
            if (f <= e) {
                boolean overlap;
                long num = e - f + 1L;
                assert (num > 0L);
                boolean bl = overlap = a1 == a2 && f < t && t <= e;
                if (!TableUtil.hasIndexMetamethod(a1) && !TableUtil.hasNewIndexMetamethod(a2)) {
                    if (overlap) {
                        for (long idx = num - 1L; idx >= 0L; --idx) {
                            a2.rawset(t + idx, a1.rawget(f + idx));
                        }
                    } else {
                        for (long idx = 0L; idx < num; ++idx) {
                            a2.rawset(t + idx, a1.rawget(f + idx));
                        }
                    }
                    context.getReturnBuffer().setTo(a2);
                } else {
                    long idx = overlap ? num - 1L : 0L;
                    this._run(context, 0, a1, a2, f, t, idx, num, !overlap);
                }
            } else {
                context.getReturnBuffer().setTo(a2);
            }
        }

        private void _run(ExecutionContext context, int state, Table a1, Table a2, long f, long t, long idx, long num, boolean asc) throws ResolvedControlThrowable {
            try {
                block8: while (true) {
                    switch (state) {
                        case 0: {
                            boolean done;
                            boolean bl = asc ? idx >= num : (done = idx < 0L);
                            if (done) {
                                context.getReturnBuffer().setTo(a2);
                                return;
                            }
                        }
                        case 1: {
                            state = 2;
                            Dispatch.index(context, a1, f + idx);
                        }
                        case 2: {
                            Object v = context.getReturnBuffer().get0();
                            state = 3;
                            Dispatch.setindex(context, a2, t + idx, v);
                        }
                        case 3: {
                            idx += (long)(asc ? 1 : -1);
                            state = 0;
                            continue block8;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("Illegal state: " + state);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, a1, a2, f, t, idx, num, asc));
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SuspendedState ss = (SuspendedState)suspendedState;
            this._run(context, ss.state, ss.a1, ss.a2, ss.f, ss.t, ss.idx, ss.num, ss.asc);
        }

        private static class SuspendedState {
            public final int state;
            public final Table a1;
            public final Table a2;
            public final long f;
            public final long t;
            public final long idx;
            public final long num;
            public final boolean asc;

            private SuspendedState(int state, Table a1, Table a2, long f, long t, long idx, long num, boolean asc) {
                this.state = state;
                this.a1 = a1;
                this.a2 = a2;
                this.f = f;
                this.t = t;
                this.idx = idx;
                this.num = num;
                this.asc = asc;
            }
        }
    }

    static class Insert
    extends AbstractLibFunction {
        private static final int PHASE_SHIFT = 3;
        private static final int _LEN = 0;
        private static final int _LOOP = 1;
        private static final int _END = 2;
        private static final int _LEN_PREPARE = 0;
        private static final int _LEN_RESUME = 1;
        private static final int _LOOP_TEST = 8;
        private static final int _LOOP_TABGET = 9;
        private static final int _LOOP_TABSET = 10;
        private static final int _END_TABSET = 16;
        private static final int _END_RETURN = 17;

        Insert() {
        }

        @Override
        protected String name() {
            return "insert";
        }

        private void checkValidPos(long pos, long len) {
            if (pos < 1L || pos > len + 1L) {
                throw new BadArgumentException(2, this.name(), "position out of bounds");
            }
        }

        private static void rawInsert(Table t, long pos, long len, Object value) {
            for (long k = len + 1L; k > pos; --k) {
                t.rawset(k, t.rawget(k - 1L));
            }
            t.rawset(pos, value);
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            Table t = args.nextTable();
            if (!TableUtil.hasLenMetamethod(t)) {
                this.run_args(context, t, args, t.rawlen());
            } else {
                this._len(context, 0, t, args);
            }
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SuspendedState ss = (SuspendedState)suspendedState;
            switch (ss.state >> 3) {
                case 0: {
                    this._len(context, ss.state, ss.t, ss.args);
                    break;
                }
                case 1: {
                    this._loop(context, ss.state, ss.t, ss.pos, ss.len, ss.value);
                    break;
                }
                case 2: {
                    this._end(context, ss.state, ss.t, ss.pos, ss.value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal state: " + ss.state);
                }
            }
        }

        private void _len(ExecutionContext context, int state, Table t, ArgumentIterator args) throws ResolvedControlThrowable {
            long len;
            try {
                switch (state) {
                    case 0: {
                        state = 1;
                        Dispatch.len(context, t);
                    }
                    case 1: {
                        len = TableLib.getLength(context.getReturnBuffer());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal state: " + state);
                    }
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, t, args, 0L, 0L, null));
            }
            this.run_args(context, t, args, len);
        }

        private void run_args(ExecutionContext context, Table t, ArgumentIterator args, long len) throws ResolvedControlThrowable {
            Object value;
            long pos;
            if (args.size() == 2) {
                pos = len + 1L;
                value = args.nextAny();
            } else if (args.size() == 3) {
                pos = args.nextInteger();
                this.checkValidPos(pos, len);
                value = args.nextAny();
            } else {
                throw new LuaRuntimeException((Object)"wrong number of arguments to 'insert'");
            }
            this.start_loop(context, t, pos, len, value);
        }

        private void start_loop(ExecutionContext context, Table t, long pos, long len, Object value) throws ResolvedControlThrowable {
            if (!TableUtil.hasIndexMetamethod(t) && !TableUtil.hasNewIndexMetamethod(t)) {
                Insert.rawInsert(t, pos, len, value);
                context.getReturnBuffer().setTo();
            } else {
                this._loop(context, 8, t, pos, len + 2L, value);
            }
        }

        private void _loop(ExecutionContext context, int state, Table t, long pos, long k, Object value) throws ResolvedControlThrowable {
            try {
                block7: while (true) {
                    switch (state) {
                        case 8: {
                            state = 9;
                            if (--k <= pos) break block7;
                        }
                        case 9: {
                            state = 10;
                            Dispatch.index(context, t, k - 1L);
                        }
                        case 10: {
                            state = 8;
                            Object v = context.getReturnBuffer().get0();
                            Dispatch.setindex(context, t, k, v);
                            continue block7;
                        }
                        default: {
                            throw new IllegalStateException("Illegal state: " + state);
                        }
                    }
                    break;
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, t, null, pos, k, value));
            }
            state = 16;
            this._end(context, state, t, pos, value);
        }

        private void _end(ExecutionContext context, int state, Table t, long pos, Object value) throws ResolvedControlThrowable {
            try {
                switch (state) {
                    case 16: {
                        state = 17;
                        Dispatch.setindex(context, t, pos, value);
                    }
                    case 17: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal state: " + state);
                    }
                }
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, t, null, pos, -1L, value));
            }
            context.getReturnBuffer().setTo();
        }

        private static class SuspendedState {
            public final int state;
            public final Table t;
            public final ArgumentIterator args;
            public final long pos;
            public final long len;
            public final Object value;

            private SuspendedState(int state, Table t, ArgumentIterator args, long pos, long len, Object value) {
                this.state = state;
                this.t = t;
                this.args = args;
                this.pos = pos;
                this.len = len;
                this.value = value;
            }
        }
    }

    static class Concat
    extends AbstractLibFunction {
        private static final int STATE_LEN_PREPARE = 0;
        private static final int STATE_LEN_RESUME = 1;
        private static final int STATE_BEFORE_LOOP = 2;
        private static final int STATE_LOOP = 3;

        Concat() {
        }

        @Override
        protected String name() {
            return "concat";
        }

        private static void appendToBuilder(ByteStringBuilder bld, long index, Object o) {
            ByteString s = Conversions.stringValueOf(o);
            if (s == null) {
                throw new LuaRuntimeException((Object)("invalid value (" + PlainValueTypeNamer.INSTANCE.typeNameOf(o) + ") at index " + index + " in table for 'concat'"));
            }
            bld.append(s);
        }

        private static void concatUsingRawGet(ExecutionContext context, Table t, ByteString sep, long i, long j) {
            ByteStringBuilder bld = new ByteStringBuilder();
            for (long k = i; k <= j; ++k) {
                Object o = t.rawget(k);
                Concat.appendToBuilder(bld, k, o);
                if (k + 1L > j) continue;
                bld.append(sep);
            }
            context.getReturnBuffer().setTo(bld.toByteString());
        }

        private void run(ExecutionContext context, int state, Table t, ArgumentIterator args, ByteString sep, long i, long j, long k, ByteStringBuilder bld) throws ResolvedControlThrowable {
            try {
                switch (state) {
                    case 0: {
                        state = 1;
                        Dispatch.len(context, t);
                    }
                    case 1: {
                        k = TableLib.getLength(context.getReturnBuffer());
                    }
                    case 2: {
                        long len = k;
                        k = 0L;
                        sep = args.nextOptionalString(ByteString.empty());
                        args.goTo(2);
                        i = args.nextOptionalInteger(1L);
                        args.goTo(3);
                        j = args.nextOptionalInteger(len);
                        args = null;
                        if (!TableUtil.hasIndexMetamethod(t)) {
                            Concat.concatUsingRawGet(context, t, sep, i, j);
                            return;
                        }
                        if (i <= j) {
                            k = i;
                            state = 3;
                            bld = new ByteStringBuilder();
                            Dispatch.index(context, t, k++);
                        } else {
                            context.getReturnBuffer().setTo("");
                            return;
                        }
                    }
                    case 3: {
                        while (true) {
                            Object v = context.getReturnBuffer().get0();
                            Concat.appendToBuilder(bld, k, v);
                            if (k > j) break;
                            bld.append(sep);
                            state = 3;
                            Dispatch.index(context, t, k++);
                        }
                        assert (k > j);
                        context.getReturnBuffer().setTo(bld.toByteString());
                        return;
                    }
                }
                throw new IllegalStateException("Illegal state: " + state);
            }
            catch (UnresolvedControlThrowable ct) {
                throw ct.resolve(this, new SuspendedState(state, t, args, sep, i, j, k, bld));
            }
        }

        @Override
        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            long k;
            int state;
            Table t = args.nextTable();
            if (!TableUtil.hasLenMetamethod(t)) {
                state = 2;
                k = t.rawlen();
            } else {
                state = 0;
                k = 0L;
            }
            this.run(context, state, t, args, null, 0L, 0L, k, null);
        }

        @Override
        public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
            SuspendedState ss = (SuspendedState)suspendedState;
            this.run(context, ss.state, ss.t, ss.args, ss.sep, ss.i, ss.j, ss.k, ss.bld);
        }

        private static class SuspendedState {
            public final int state;
            public final Table t;
            public final ArgumentIterator args;
            public final ByteString sep;
            public final long i;
            public final long j;
            public final long k;
            public final ByteStringBuilder bld;

            public SuspendedState(int state, Table t, ArgumentIterator args, ByteString sep, long i, long j, long k, ByteStringBuilder bld) {
                this.state = state;
                this.t = t;
                this.args = args;
                this.sep = sep;
                this.i = i;
                this.j = j;
                this.k = k;
                this.bld = bld;
            }
        }
    }
}

