/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.load;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.classdump.luna.load.CompiledChunk;
import org.classdump.luna.util.ByteVector;

public class ChunkClassLoader
extends ClassLoader {
    private final Map<String, ByteVector> installed = new HashMap<String, ByteVector>();
    private final Set<String> loaded = new HashSet<String>();

    public ChunkClassLoader(ClassLoader parent) {
        super(parent);
    }

    public ChunkClassLoader() {
        this(ChunkClassLoader.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String install(CompiledChunk chunk) {
        Map<String, ByteVector> classes = chunk.classMap();
        ChunkClassLoader chunkClassLoader = this;
        synchronized (chunkClassLoader) {
            for (String name : classes.keySet()) {
                if (this.installed.containsKey(name) || this.loaded.contains(name)) {
                    throw new IllegalStateException("Class already installed: " + name);
                }
                this.installed.put(name, classes.get(name));
            }
            String main = chunk.mainClassName();
            assert (this.installed.containsKey(main));
            return main;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstalled(String className) {
        ChunkClassLoader chunkClassLoader = this;
        synchronized (chunkClassLoader) {
            return this.installed.containsKey(className) || this.loaded.contains(className);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ChunkClassLoader chunkClassLoader = this;
        synchronized (chunkClassLoader) {
            ByteVector bv = this.installed.remove(name);
            if (bv != null) {
                this.loaded.add(name);
                return this.defineClass(name, bv);
            }
            throw new ClassNotFoundException(name);
        }
    }

    private Class<?> defineClass(String name, ByteVector bytes) {
        byte[] byteArray = bytes.copyToNewArray();
        return this.defineClass(name, byteArray, 0, byteArray.length);
    }
}

