/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser;

import java.util.List;
import java.util.Objects;
import org.classdump.luna.parser.Exprs;
import org.classdump.luna.parser.SourceElement;
import org.classdump.luna.parser.ast.CallExpr;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.IndexExpr;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.SourceInfo;

abstract class PostfixOp {
    PostfixOp() {
    }

    public abstract Expr on(Expr var1);

    static class Invoke
    extends PostfixOp {
        private final Name method;
        private final SourceElement<List<Expr>> args;

        public Invoke(SourceElement<List<Expr>> args, Name method) {
            this.args = Objects.requireNonNull(args);
            this.method = method;
        }

        @Override
        public CallExpr on(Expr exp) {
            return this.method != null ? Exprs.methodCall(this.args.sourceInfo(), exp, this.method, this.args.element()) : Exprs.functionCall(this.args.sourceInfo(), exp, this.args.element());
        }
    }

    static class FieldAccess
    extends PostfixOp {
        private final SourceInfo src;
        private final Expr keyExpr;

        public FieldAccess(SourceInfo src, Expr keyExpr) {
            this.src = Objects.requireNonNull(src);
            this.keyExpr = Objects.requireNonNull(keyExpr);
        }

        public Expr keyExpr() {
            return this.keyExpr;
        }

        @Override
        public IndexExpr on(Expr exp) {
            return Exprs.index(this.src, exp, this.keyExpr);
        }
    }
}

