/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.parser.ast.Attributes;
import org.classdump.luna.parser.ast.Block;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.Transformer;

public class FunctionDefExpr
extends Expr {
    private final Params params;
    private final Block block;

    public FunctionDefExpr(Attributes attr, Params params, Block block) {
        super(attr);
        this.params = Objects.requireNonNull(params);
        this.block = Objects.requireNonNull(block);
    }

    public Params params() {
        return this.params;
    }

    public Block block() {
        return this.block;
    }

    public FunctionDefExpr update(Params params, Block block) {
        if (this.params.equals(params) && this.block.equals(block)) {
            return this;
        }
        return new FunctionDefExpr(this.attributes(), params, block);
    }

    public FunctionDefExpr withAttributes(Attributes attr) {
        if (this.attributes().equals(attr)) {
            return this;
        }
        return new FunctionDefExpr(attr, this.params, this.block);
    }

    public FunctionDefExpr with(Object o) {
        return this.withAttributes(this.attributes().with(o));
    }

    @Override
    public Expr accept(Transformer tf) {
        return tf.transform(this);
    }

    public static class Params {
        private final List<Name> names;
        private final boolean vararg;

        public Params(List<Name> names, boolean vararg) {
            this.names = Objects.requireNonNull(names);
            this.vararg = vararg;
        }

        public static Params empty() {
            return new Params(Collections.emptyList(), false);
        }

        public static Params emptyVararg() {
            return new Params(Collections.emptyList(), true);
        }

        public List<Name> names() {
            return this.names;
        }

        public boolean isVararg() {
            return this.vararg;
        }

        public Params update(List<Name> names, boolean vararg) {
            if (this.names.equals(names) && this.vararg == vararg) {
                return this;
            }
            return new Params(names, vararg);
        }
    }
}

