/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.runtime;

import java.util.Objects;
import org.classdump.luna.Conversions;
import org.classdump.luna.runtime.Dispatch;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.ProtectedResumable;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.Resumable;

class ResumeInfo {
    public final Resumable resumable;
    public final Object savedState;

    public ResumeInfo(Resumable resumable, Object savedState) {
        this.resumable = Objects.requireNonNull(resumable);
        this.savedState = savedState;
    }

    public boolean resume(ExecutionContext context, Throwable error) throws ResolvedControlThrowable {
        if (error == null) {
            this.resumable.resume(context, this.savedState);
            Dispatch.evaluateTailCalls(context);
            return true;
        }
        if (this.resumable instanceof ProtectedResumable) {
            ProtectedResumable pr = (ProtectedResumable)this.resumable;
            pr.resumeError(context, this.savedState, Conversions.toErrorObject(error));
            Dispatch.evaluateTailCalls(context);
            return true;
        }
        return false;
    }
}

