/*
 * Copyright 2016 Miroslav Janíček
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.classdump.luna.compiler.ir;

import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.ir.Var;

import java.util.Objects;

public class VarLoad extends BodyNode {

	private final Val dest;
	private final Var var;

	public VarLoad(Val dest, Var var) {
		this.dest = Objects.requireNonNull(dest);
		this.var = Objects.requireNonNull(var);
	}

	public Val dest() {
		return dest;
	}

	public Var var() {
		return var;
	}

	@Override
	public void accept(IRVisitor visitor) {
		visitor.visit(this);
	}

}
