/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import org.classdump.luna.ByteString;
import org.classdump.luna.Table;
import org.classdump.luna.Userdata;
import org.classdump.luna.runtime.Coroutine;
import org.classdump.luna.runtime.LuaFunction;

public enum LuaType {
    NIL,
    BOOLEAN,
    NUMBER,
    STRING,
    FUNCTION,
    USERDATA,
    THREAD,
    TABLE;


    public static LuaType typeOf(Object o) {
        if (o == null) {
            return NIL;
        }
        if (o instanceof Boolean) {
            return BOOLEAN;
        }
        if (o instanceof Number) {
            return NUMBER;
        }
        if (o instanceof ByteString || o instanceof String) {
            return STRING;
        }
        if (o instanceof Table) {
            return TABLE;
        }
        if (o instanceof LuaFunction) {
            return FUNCTION;
        }
        if (o instanceof Coroutine) {
            return THREAD;
        }
        return USERDATA;
    }

    public static boolean isNil(Object o) {
        return o == null;
    }

    public static boolean isBoolean(Object o) {
        return o instanceof Boolean;
    }

    public static boolean isNumber(Object o) {
        return o instanceof Number;
    }

    public static boolean isFloat(Object o) {
        return o instanceof Double || o instanceof Float;
    }

    public static boolean isInteger(Object o) {
        return LuaType.isNumber(o) && !LuaType.isFloat(o);
    }

    public static boolean isString(Object o) {
        return o instanceof ByteString || o instanceof String;
    }

    public static boolean isFunction(Object o) {
        return o instanceof LuaFunction;
    }

    public static boolean isUserdata(Object o) {
        return LuaType.typeOf(o) == USERDATA;
    }

    public static boolean isFullUserdata(Object o) {
        return o instanceof Userdata;
    }

    public static boolean isLightUserdata(Object o) {
        return !LuaType.isFullUserdata(o) && LuaType.isUserdata(o);
    }

    public static boolean isThread(Object o) {
        return o instanceof Coroutine;
    }

    public static boolean isTable(Object o) {
        return o instanceof Table;
    }
}

