/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import java.util.Comparator;
import org.classdump.luna.ByteString;
import org.classdump.luna.LuaMathOperators;
import org.classdump.luna.LuaType;

public abstract class Ordering<T>
implements Comparator<T> {
    public static final NumericOrdering NUMERIC = new NumericOrdering();
    public static final StringOrdering STRING = new StringOrdering();
    private static final NumericObjectOrdering NUMERIC_OBJECT = new NumericObjectOrdering();
    private static final StringObjectOrdering STRING_OBJECT = new StringObjectOrdering();

    private Ordering() {
    }

    public abstract boolean eq(T var1, T var2);

    public abstract boolean lt(T var1, T var2);

    public abstract boolean le(T var1, T var2);

    public static boolean isRawEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            return NUMERIC.eq((Number)a, (Number)b);
        }
        if (LuaType.isString(a) && LuaType.isString(b)) {
            return STRING.eq(Ordering.toByteString(a), Ordering.toByteString(b));
        }
        return a.equals(b);
    }

    private static ByteString toByteString(Object o) throws ClassCastException {
        if (o instanceof ByteString) {
            return (ByteString)o;
        }
        return ByteString.of((String)o);
    }

    public static Ordering<Object> of(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return NUMERIC_OBJECT;
        }
        if (LuaType.isString(a) && LuaType.isString(b)) {
            return STRING_OBJECT;
        }
        return null;
    }

    private static class StringObjectOrdering
    extends Ordering<Object> {
        private StringObjectOrdering() {
        }

        @Override
        public boolean eq(Object a, Object b) {
            return STRING.eq(Ordering.toByteString(a), Ordering.toByteString(b));
        }

        @Override
        public boolean lt(Object a, Object b) {
            return STRING.lt(Ordering.toByteString(a), Ordering.toByteString(b));
        }

        @Override
        public boolean le(Object a, Object b) {
            return STRING.le(Ordering.toByteString(a), Ordering.toByteString(b));
        }

        @Override
        public int compare(Object a, Object b) {
            return STRING.compare(Ordering.toByteString(a), Ordering.toByteString(b));
        }
    }

    private static class NumericObjectOrdering
    extends Ordering<Object> {
        private NumericObjectOrdering() {
        }

        @Override
        public boolean eq(Object a, Object b) {
            return NUMERIC.eq((Number)a, (Number)b);
        }

        @Override
        public boolean lt(Object a, Object b) {
            return NUMERIC.lt((Number)a, (Number)b);
        }

        @Override
        public boolean le(Object a, Object b) {
            return NUMERIC.le((Number)a, (Number)b);
        }

        @Override
        public int compare(Object a, Object b) {
            return NUMERIC.compare((Number)a, (Number)b);
        }
    }

    public static final class StringOrdering
    extends Ordering<ByteString> {
        private StringOrdering() {
        }

        @Override
        public boolean eq(ByteString a, ByteString b) {
            return a.compareTo(b) == 0;
        }

        @Override
        public boolean lt(ByteString a, ByteString b) {
            return a.compareTo(b) < 0;
        }

        @Override
        public boolean le(ByteString a, ByteString b) {
            return a.compareTo(b) <= 0;
        }

        @Override
        public int compare(ByteString a, ByteString b) {
            return a.compareTo(b);
        }
    }

    public static final class NumericOrdering
    extends Ordering<Number> {
        private NumericOrdering() {
        }

        @Override
        public boolean eq(Number a, Number b) {
            boolean isflt_b;
            boolean isflt_a = a instanceof Double || a instanceof Float;
            boolean bl = isflt_b = b instanceof Double || b instanceof Float;
            if (isflt_a) {
                return isflt_b ? LuaMathOperators.eq(a.doubleValue(), b.doubleValue()) : LuaMathOperators.eq(a.doubleValue(), b.longValue());
            }
            return isflt_b ? LuaMathOperators.eq(a.longValue(), b.doubleValue()) : LuaMathOperators.eq(a.longValue(), b.longValue());
        }

        @Override
        public boolean lt(Number a, Number b) {
            boolean isflt_b;
            boolean isflt_a = a instanceof Double || a instanceof Float;
            boolean bl = isflt_b = b instanceof Double || b instanceof Float;
            if (isflt_a) {
                return isflt_b ? LuaMathOperators.lt(a.doubleValue(), b.doubleValue()) : LuaMathOperators.lt(a.doubleValue(), b.longValue());
            }
            return isflt_b ? LuaMathOperators.lt(a.longValue(), b.doubleValue()) : LuaMathOperators.lt(a.longValue(), b.longValue());
        }

        @Override
        public boolean le(Number a, Number b) {
            boolean isflt_b;
            boolean isflt_a = a instanceof Double || a instanceof Float;
            boolean bl = isflt_b = b instanceof Double || b instanceof Float;
            if (isflt_a) {
                return isflt_b ? LuaMathOperators.le(a.doubleValue(), b.doubleValue()) : LuaMathOperators.le(a.doubleValue(), b.longValue());
            }
            return isflt_b ? LuaMathOperators.le(a.longValue(), b.doubleValue()) : LuaMathOperators.le(a.longValue(), b.longValue());
        }

        @Override
        public int compare(Number a, Number b) {
            if (this.lt(a, b)) {
                return -1;
            }
            if (this.lt(b, a)) {
                return 1;
            }
            return Double.compare(a.doubleValue(), b.doubleValue());
        }
    }
}

