/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler;

import java.util.Objects;

public final class CompilerSettings {
    public static final CPUAccountingMode DEFAULT_CPU_ACCOUNTING_MODE = CPUAccountingMode.IN_EVERY_BASIC_BLOCK;
    public static final boolean DEFAULT_CONST_FOLDING_MODE = true;
    public static final boolean DEFAULT_CONST_CACHING_MODE = true;
    public static final boolean DEFAULT_BYTE_STRING_MODE = true;
    public static final int DEFAULT_NODE_SIZE_LIMIT = 2000;
    private final CPUAccountingMode cpuAccountingMode;
    private final boolean constFolding;
    private final boolean constCaching;
    private final boolean byteStrings;
    private final int nodeSizeLimit;

    CompilerSettings(CPUAccountingMode cpuAccountingMode, boolean constFolding, boolean constCaching, boolean byteStrings, int nodeSizeLimit) {
        this.cpuAccountingMode = Objects.requireNonNull(cpuAccountingMode);
        this.constFolding = constFolding;
        this.constCaching = constCaching;
        this.byteStrings = byteStrings;
        this.nodeSizeLimit = nodeSizeLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompilerSettings that = (CompilerSettings)o;
        return this.cpuAccountingMode == that.cpuAccountingMode && this.constFolding == that.constFolding && this.constCaching == that.constCaching && this.byteStrings == that.byteStrings && this.nodeSizeLimit == that.nodeSizeLimit;
    }

    public int hashCode() {
        int result = this.cpuAccountingMode.hashCode();
        result = 31 * result + (this.constFolding ? 1 : 0);
        result = 31 * result + (this.constCaching ? 1 : 0);
        result = 31 * result + (this.byteStrings ? 1 : 0);
        result = 31 * result + this.nodeSizeLimit;
        return result;
    }

    public static CompilerSettings of(CPUAccountingMode cpuAccountingMode, boolean constFolding, boolean constCaching, boolean byteStrings, int nodeSizeLimit) {
        return new CompilerSettings(cpuAccountingMode, constFolding, constCaching, byteStrings, nodeSizeLimit);
    }

    public static CompilerSettings defaultSettings() {
        return CompilerSettings.of(DEFAULT_CPU_ACCOUNTING_MODE, true, true, true, 2000);
    }

    public static CompilerSettings defaultNoAccountingSettings() {
        return CompilerSettings.defaultSettings().withCPUAccountingMode(CPUAccountingMode.NO_CPU_ACCOUNTING);
    }

    public CPUAccountingMode cpuAccountingMode() {
        return this.cpuAccountingMode;
    }

    public boolean constFolding() {
        return this.constFolding;
    }

    public boolean constCaching() {
        return this.constCaching;
    }

    public boolean byteStrings() {
        return this.byteStrings;
    }

    public int nodeSizeLimit() {
        return this.nodeSizeLimit;
    }

    public CompilerSettings withCPUAccountingMode(CPUAccountingMode mode) {
        return mode != this.cpuAccountingMode ? new CompilerSettings(mode, this.constFolding, this.constCaching, this.byteStrings, this.nodeSizeLimit) : this;
    }

    public CompilerSettings withConstFolding(boolean mode) {
        return mode != this.constFolding ? new CompilerSettings(this.cpuAccountingMode, mode, this.constCaching, this.byteStrings, this.nodeSizeLimit) : this;
    }

    public CompilerSettings withConstCaching(boolean mode) {
        return mode != this.constCaching ? new CompilerSettings(this.cpuAccountingMode, this.constFolding, mode, this.byteStrings, this.nodeSizeLimit) : this;
    }

    public CompilerSettings withByteStrings(boolean mode) {
        return mode != this.byteStrings ? new CompilerSettings(this.cpuAccountingMode, this.constFolding, this.constCaching, mode, this.nodeSizeLimit) : this;
    }

    public CompilerSettings withNodeSizeLimit(int limit) {
        return limit != this.nodeSizeLimit ? new CompilerSettings(this.cpuAccountingMode, this.constFolding, this.constCaching, this.byteStrings, limit) : this;
    }

    public static enum CPUAccountingMode {
        NO_CPU_ACCOUNTING,
        IN_EVERY_BASIC_BLOCK;

    }
}

